/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.condition.internal.CompositeConditionSupport;
import org.sonatype.nexus.common.event.EventManager;

public class ConjunctionCondition
extends CompositeConditionSupport
implements Condition {
    private Condition lastNotSatisfied;

    public ConjunctionCondition(EventManager eventManager, Condition ... conditions) {
        super(eventManager, conditions);
    }

    @Override
    protected boolean reevaluate(Condition ... conditions) {
        Condition[] conditionArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (!condition.isSatisfied()) {
                this.lastNotSatisfied = condition;
                return false;
            }
            ++n2;
        }
        this.lastNotSatisfied = null;
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(condition);
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String explainSatisfied() {
        StringBuilder sb = new StringBuilder();
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(condition.explainSatisfied());
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String explainUnsatisfied() {
        if (this.lastNotSatisfied != null) {
            return this.lastNotSatisfied.explainUnsatisfied();
        }
        StringBuilder sb = new StringBuilder();
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(condition.explainUnsatisfied());
            ++n2;
        }
        return sb.toString();
    }
}

