/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityContextAware;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.ConditionEvent;
import org.sonatype.nexus.capability.condition.ConditionSupport;
import org.sonatype.nexus.common.event.EventManager;

public abstract class CompositeConditionSupport
extends ConditionSupport
implements CapabilityContextAware {
    private final Condition[] conditions;

    public CompositeConditionSupport(EventManager eventManager, Condition ... conditions) {
        super(eventManager, false);
        this.conditions = (Condition[])Preconditions.checkNotNull((Object)conditions);
        Preconditions.checkArgument((conditions.length > 1 ? 1 : 0) != 0, (Object)"A composite mush have at least 2 conditions");
    }

    public CompositeConditionSupport(EventManager eventManager, Condition condition) {
        super(eventManager, false);
        this.conditions = new Condition[]{(Condition)Preconditions.checkNotNull((Object)condition)};
    }

    @Override
    protected void doBind() {
        Condition[] conditionArray = this.conditions;
        int n = this.conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            condition.bind();
            ++n2;
        }
        this.getEventManager().register((Object)this);
        this.setSatisfied(this.reevaluate(this.conditions));
    }

    @Override
    public void doRelease() {
        this.getEventManager().unregister((Object)this);
        Condition[] conditionArray = this.conditions;
        int n = this.conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            condition.release();
            ++n2;
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Satisfied event) {
        if (this.shouldReevaluateFor(event.getCondition())) {
            this.setSatisfied(this.reevaluate(this.conditions));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Unsatisfied event) {
        if (this.shouldReevaluateFor(event.getCondition())) {
            this.setSatisfied(this.reevaluate(this.conditions));
        }
    }

    @Override
    public CompositeConditionSupport setContext(CapabilityContext context) {
        Condition[] conditionArray = this.conditions;
        int n = this.conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (condition instanceof CapabilityContextAware) {
                ((CapabilityContextAware)((Object)condition)).setContext(context);
            }
            ++n2;
        }
        return this;
    }

    public String toString() {
        return "Re-evaluate " + this;
    }

    protected abstract boolean reevaluate(Condition ... var1);

    protected Condition[] getConditions() {
        return this.conditions;
    }

    private boolean shouldReevaluateFor(Condition condition) {
        Condition[] conditionArray = this.conditions;
        int n = this.conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition watched = conditionArray[n2];
            if (watched == condition) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

