/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.nexus.capability.CapabilityDescriptor;
import org.sonatype.nexus.capability.CapabilityDescriptorRegistry;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.condition.ConditionSupport;
import org.sonatype.nexus.common.event.EventManager;

public class CapabilityOfTypeExistsCondition
extends ConditionSupport {
    private final CapabilityRegistry capabilityRegistry;
    private final ReentrantReadWriteLock bindLock;
    final CapabilityType type;
    final String typeName;

    public CapabilityOfTypeExistsCondition(EventManager eventManager, CapabilityDescriptorRegistry descriptorRegistry, CapabilityRegistry capabilityRegistry, CapabilityType type) {
        super(eventManager);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.type = (CapabilityType)Preconditions.checkNotNull((Object)type);
        CapabilityDescriptor descriptor = ((CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)descriptorRegistry)).get(type);
        this.typeName = descriptor == null ? type.toString() : descriptor.name();
        this.bindLock = new ReentrantReadWriteLock();
    }

    @Override
    protected void doBind() {
        try {
            this.bindLock.writeLock().lock();
            for (CapabilityReference capabilityReference : this.capabilityRegistry.getAll()) {
                this.handle(new CapabilityEvent.Created(this.capabilityRegistry, capabilityReference));
            }
        }
        finally {
            this.bindLock.writeLock().unlock();
        }
        this.getEventManager().register((Object)this);
    }

    @Override
    public void doRelease() {
        this.getEventManager().unregister((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.Created event) {
        if (!this.isSatisfied() && this.type.equals(event.getReference().context().type())) {
            this.checkAllCapabilities();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterRemove event) {
        if (this.isSatisfied() && this.type.equals(event.getReference().context().type())) {
            this.checkAllCapabilities();
        }
    }

    void checkAllCapabilities() {
        for (CapabilityReference capabilityReference : this.capabilityRegistry.getAll()) {
            if (!this.isSatisfiedBy(capabilityReference)) continue;
            this.setSatisfied(true);
            return;
        }
        this.setSatisfied(false);
    }

    boolean isSatisfiedBy(CapabilityReference reference) {
        return this.type.equals(reference.context().type());
    }

    @Override
    protected void setSatisfied(boolean satisfied) {
        try {
            this.bindLock.readLock().lock();
            super.setSatisfied(satisfied);
        }
        finally {
            this.bindLock.readLock().unlock();
        }
    }

    public String toString() {
        return this.type + " exists";
    }

    @Override
    public String explainSatisfied() {
        return String.valueOf(this.typeName) + " exists";
    }

    @Override
    public String explainUnsatisfied() {
        return String.valueOf(this.typeName) + " does not exist";
    }
}

