/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityContextAware;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.condition.ConditionSupport;
import org.sonatype.nexus.common.event.EventManager;

public class CapabilityHasNoDuplicatesCondition
extends ConditionSupport
implements CapabilityContextAware {
    private CapabilityContext context;

    public CapabilityHasNoDuplicatesCondition(EventManager eventManager) {
        super(eventManager);
    }

    @Override
    public CapabilityHasNoDuplicatesCondition setContext(CapabilityContext context) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot contextualize when already bounded");
        Preconditions.checkState((this.context == null ? 1 : 0) != 0, (Object)("Already contextualized with '" + this.context + "'"));
        this.context = context;
        return this;
    }

    @Override
    protected void doBind() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"Not yet contextualized");
        this.checkForDuplicates();
        this.getEventManager().register((Object)this);
    }

    @Override
    public void doRelease() {
        this.getEventManager().unregister((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.Created event) {
        this.checkForDuplicates(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterUpdate event) {
        this.checkForDuplicates(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterRemove event) {
        this.checkForDuplicates(event);
    }

    private void checkForDuplicates(CapabilityEvent event) {
        if (event.getReference().context().type().equals(this.context.type())) {
            this.checkForDuplicates();
        }
    }

    private void checkForDuplicates() {
        this.setSatisfied(!this.context.descriptor().isDuplicated(this.context.id(), this.context.properties()));
    }

    public String toString() {
        return "Has no duplicates: " + this.context.id();
    }

    @Override
    public String explainSatisfied() {
        return "Capability has no duplicates";
    }

    @Override
    public String explainUnsatisfied() {
        return "Capability is duplicated by another capability";
    }
}

