/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityDescriptor;
import org.sonatype.nexus.common.db.DatabaseCheck;

@Named
@Singleton
public class DefaultCapabilityDescriptorProvider {
    private final Map<String, CapabilityDescriptor> descriptors;
    private final DatabaseCheck databaseCheck;

    @Inject
    public DefaultCapabilityDescriptorProvider(Map<String, CapabilityDescriptor> descriptors, DatabaseCheck databaseCheck) {
        this.descriptors = (Map)Preconditions.checkNotNull(descriptors);
        this.databaseCheck = (DatabaseCheck)Preconditions.checkNotNull((Object)databaseCheck);
    }

    public List<CapabilityDescriptor> get() {
        return this.descriptors.values().stream().filter(capabilityDescriptor -> this.databaseCheck.isAllowedByVersion(capabilityDescriptor.getClass())).collect(Collectors.toList());
    }
}

