/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityType;

public class CapabilityReferenceFilterBuilder {
    private CapabilityReferenceFilterBuilder() {
    }

    public static CapabilityReferenceFilter capabilities() {
        return new CapabilityReferenceFilter();
    }

    public static class CapabilityReferenceFilter
    implements Predicate<CapabilityReference> {
        private String typeId;
        private CapabilityIdentity ignoreCapabilityId;
        private Boolean enabled;
        private Boolean active;
        private Boolean includeNotExposed = false;
        private Map<String, String> properties = new HashMap<String, String>();

        public String getTypeId() {
            return this.typeId;
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        public Boolean isActive() {
            return this.active;
        }

        public Boolean isIncludeNotExposed() {
            return this.includeNotExposed;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public CapabilityReferenceFilter withType(CapabilityType type) {
            this.typeId = type.toString();
            return this;
        }

        public CapabilityReferenceFilter ignore(CapabilityIdentity id) {
            this.ignoreCapabilityId = id;
            return this;
        }

        public CapabilityReferenceFilter enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public CapabilityReferenceFilter enabled() {
            this.enabled = true;
            return this;
        }

        public CapabilityReferenceFilter disabled() {
            this.enabled = false;
            return this;
        }

        public CapabilityReferenceFilter active(boolean active) {
            this.active = active;
            return this;
        }

        public CapabilityReferenceFilter active() {
            this.active = true;
            return this;
        }

        public CapabilityReferenceFilter passive() {
            this.active = false;
            return this;
        }

        public CapabilityReferenceFilter withBoundedProperty(String key) {
            this.properties.put(key, null);
            return this;
        }

        public CapabilityReferenceFilter withProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public CapabilityReferenceFilter onRepository(String key, String repositoryId) {
            return this.withProperty(key, repositoryId);
        }

        public CapabilityReferenceFilter includeNotExposed() {
            this.includeNotExposed = true;
            return this;
        }

        public boolean apply(CapabilityReference input) {
            if (input == null) {
                return false;
            }
            if (input.context().descriptor() != null && !input.context().descriptor().isExposed() && !this.includeNotExposed.booleanValue()) {
                return false;
            }
            if (this.typeId != null && !this.typeId.equals(input.context().type().toString())) {
                return false;
            }
            if (this.ignoreCapabilityId != null && this.ignoreCapabilityId.equals(input.context().id())) {
                return false;
            }
            if (this.enabled != null && !this.enabled.equals(input.context().isEnabled())) {
                return false;
            }
            if (this.active != null && !this.active.equals(input.context().isActive())) {
                return false;
            }
            if (this.properties != null && !this.properties.isEmpty()) {
                Map<String, String> inputPropertiesMap = input.context().properties();
                if (inputPropertiesMap == null || inputPropertiesMap.isEmpty()) {
                    return false;
                }
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    String inputValue;
                    String key = entry.getKey();
                    if (key == null) {
                        return false;
                    }
                    String value = entry.getValue();
                    if (!(value == null ? !inputPropertiesMap.containsKey(key) : (inputValue = inputPropertiesMap.get(key)) == null || !value.equals(inputValue))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

