/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.routing.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.routing.OrientRoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;
import org.sonatype.nexus.repository.routing.internal.orient.OrientRoutingRuleEntityAdapter;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientRoutingRuleStore
extends StateGuardLifecycleSupport
implements RoutingRuleStore {
    private static final String NONE = "none";
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientRoutingRuleEntityAdapter entityAdapter;

    @Inject
    public OrientRoutingRuleStore(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientRoutingRuleEntityAdapter entityAdapter) {
        this.databaseInstance = databaseInstance;
        this.entityAdapter = entityAdapter;
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public RoutingRule create(RoutingRule rule) {
        Preconditions.checkNotNull((Object)rule);
        OrientRoutingRuleStore.validate(rule);
        this.persist((arg_0, arg_1) -> ((OrientRoutingRuleEntityAdapter)this.entityAdapter).addEntity(arg_0, arg_1), rule);
        return rule;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(RoutingRule rule) {
        Preconditions.checkNotNull((Object)rule);
        OrientRoutingRuleStore.validate(rule);
        this.persist((arg_0, arg_1) -> ((OrientRoutingRuleEntityAdapter)this.entityAdapter).editEntity(arg_0, arg_1), rule);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<RoutingRule> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    public void delete(RoutingRule rule) {
        Preconditions.checkNotNull((Object)rule);
        OrientTransactional.inTx(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)this.castToOrientRoutingRule(rule)));
    }

    @Override
    public RoutingRule getByName(String name) {
        Preconditions.checkNotNull((Object)name);
        return (RoutingRule)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.read(db, name));
    }

    @Override
    public RoutingRule getById(String id) {
        Preconditions.checkNotNull((Object)id);
        return (RoutingRule)OrientTransactional.inTx(this.databaseInstance).call(db -> (OrientRoutingRule)this.entityAdapter.read(db, (EntityId)new DetachedEntityId(id)));
    }

    @Override
    public RoutingRule newRoutingRule() {
        return this.entityAdapter.newEntity();
    }

    @VisibleForTesting
    static void validate(RoutingRule rule) {
        ValidationErrorsException exception = new ValidationErrorsException();
        if (Strings2.isBlank((String)rule.name())) {
            exception.withError("name", "A non-empty value must be specified");
        } else if (!rule.name().matches("^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$")) {
            exception.withError("name", "Only letters, digits, underscores(_), hyphens(-), and dots(.) are allowed and may not start with underscore or dot.");
        } else if (rule.name().equalsIgnoreCase(NONE)) {
            exception.withError("name", "Rule must not be named None");
        }
        if (rule.description() == null) {
            exception.withError("description", "A non-null value must be specified");
        }
        if (rule.mode() == null) {
            exception.withError("mode", "A non-empty value must be specified");
        }
        if (rule.matchers() == null || rule.matchers().isEmpty()) {
            exception.withError("matchers", "At least one rule must be specified");
        } else {
            int index = 0;
            for (String regex : rule.matchers()) {
                if (Strings2.isBlank((String)regex)) {
                    exception.withError("matchers[" + index + "]", "Empty matchers are not allowed");
                } else {
                    try {
                        Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException e) {
                        exception.withError("matchers[" + index + "]", "Invalid regex: " + e.getMessage());
                    }
                }
                ++index;
            }
        }
        if (!exception.getValidationErrors().isEmpty()) {
            throw exception;
        }
    }

    private void persist(BiConsumer<ODatabaseDocumentTx, OrientRoutingRule> entityFunction, RoutingRule rule) {
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> entityFunction.accept(db, this.castToOrientRoutingRule(rule)));
        }
        catch (ORecordDuplicatedException e) {
            if (OrientRoutingRuleEntityAdapter.I_NAME.equals(e.getIndexName())) {
                throw new ValidationErrorsException("name", "A rule with the same name already exists. Name must be unique.");
            }
            throw e;
        }
    }

    private OrientRoutingRule castToOrientRoutingRule(RoutingRule rule) {
        Preconditions.checkArgument((boolean)(rule instanceof OrientRoutingRule), (Object)"Expected an OrientRoutingRule instance");
        return (OrientRoutingRule)rule;
    }
}

