/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.routing.internal.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.repository.routing.OrientRoutingRule;
import org.sonatype.nexus.repository.routing.RoutingMode;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.internal.orient.OrientRoutingRuleDeletedEvent;
import org.sonatype.nexus.repository.routing.internal.orient.OrientRoutingRuleUpdatedEvent;

@Named
@Singleton
public class OrientRoutingRuleEntityAdapter
extends IterableEntityAdapter<OrientRoutingRule> {
    static final String DB_CLASS = new OClassNameBuilder().prefix("repository").type("routingrule").build();
    private static final String P_NAME = "name";
    private static final String P_MATCHERS = "matchers";
    private static final String P_MODE = "mode";
    private static final String P_DESCRIPTION = "description";
    static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private final ReadEntityByPropertyAction<OrientRoutingRule> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});

    public OrientRoutingRuleEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_DESCRIPTION, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_MATCHERS, OType.EMBEDDEDLIST).setMandatory(true).setNotNull(true);
        type.createProperty(P_MODE, OType.STRING).setMandatory(true).setNotNull(true);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        this.defineType(type);
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    protected OrientRoutingRule newEntity() {
        return new OrientRoutingRule();
    }

    protected void readFields(ODocument document, OrientRoutingRule entity) throws Exception {
        String name = (String)document.field(P_NAME, OType.STRING);
        String description = (String)document.field(P_DESCRIPTION, OType.STRING);
        List matchers = (List)document.field(P_MATCHERS, OType.EMBEDDEDLIST);
        RoutingMode mode = RoutingMode.valueOf((String)document.field(P_MODE, OType.STRING));
        entity.description(description);
        entity.matchers(matchers);
        entity.name(name);
        entity.mode(mode);
    }

    protected void writeFields(ODocument document, OrientRoutingRule entity) throws Exception {
        document.field(P_MODE, (Object)entity.mode().toString());
        document.field(P_DESCRIPTION, (Object)entity.description());
        document.field(P_NAME, (Object)entity.name());
        document.field(P_MATCHERS, entity.matchers());
    }

    @Nullable
    public RoutingRule read(ODatabaseDocumentTx db, String name) {
        return (RoutingRule)this.read.execute(db, new Object[]{name});
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        this.log.trace("newEvent: eventKind: {}, metadata: {}", (Object)eventKind, (Object)metadata);
        switch (eventKind) {
            case UPDATE: {
                return new OrientRoutingRuleUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new OrientRoutingRuleDeletedEvent((EntityMetadata)metadata);
            }
        }
        return super.newEvent(document, eventKind);
    }
}

