/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.routing.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityUUID;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleCreatedEvent;
import org.sonatype.nexus.repository.routing.RoutingRuleDeletedEvent;
import org.sonatype.nexus.repository.routing.RoutingRuleInvalidatedEvent;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;
import org.sonatype.nexus.repository.routing.RoutingRuleUpdatedEvent;
import org.sonatype.nexus.repository.routing.internal.RoutingRuleDAO;
import org.sonatype.nexus.repository.routing.internal.RoutingRuleData;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class RoutingRuleStoreImpl
extends ConfigStoreSupport<RoutingRuleDAO>
implements RoutingRuleStore {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String MATCHERS = "matchers";
    private static final String MODE = "mode";
    private static final String NONE = "none";
    private final EventManager eventManager;

    @Inject
    public RoutingRuleStoreImpl(DataSessionSupplier sessionSupplier, EventManager eventManager) {
        super(sessionSupplier);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public RoutingRule newRoutingRule() {
        return new RoutingRuleData();
    }

    @Override
    @Transactional
    public List<RoutingRule> list() {
        return ImmutableList.copyOf((Iterable)((RoutingRuleDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public RoutingRule create(RoutingRule rule) {
        try {
            ((RoutingRuleDAO)this.dao()).create((RoutingRuleData)RoutingRuleStoreImpl.validate(rule));
            this.eventManager.post((Object)new RoutingRuleCreatedEvent(rule));
            return rule;
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new ValidationErrorsException(NAME, "A rule with the same name already exists. Name must be unique.");
        }
    }

    @Override
    @Transactional
    public RoutingRule getById(String id) {
        return ((RoutingRuleDAO)this.dao()).read((EntityId)new EntityUUID(UUID.fromString(id))).orElse(null);
    }

    @Override
    @Transactional
    public RoutingRule getByName(String name) {
        return ((RoutingRuleDAO)this.dao()).readByName(name).orElse(null);
    }

    @Override
    public void update(RoutingRule rule) {
        this.doUpdate((RoutingRuleData)RoutingRuleStoreImpl.validate(rule));
        this.eventManager.post((Object)new RoutingRuleUpdatedEvent(rule));
        this.postEvent(rule);
    }

    @Transactional
    protected void doUpdate(RoutingRuleData rule) {
        try {
            ((RoutingRuleDAO)this.dao()).update(rule);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new ValidationErrorsException(NAME, "A rule with the same name already exists. Name must be unique.");
        }
    }

    @Override
    public void delete(RoutingRule rule) {
        this.doDelete(rule.name());
        this.eventManager.post((Object)new RoutingRuleDeletedEvent(rule));
        this.postEvent(rule);
    }

    @Transactional
    protected void doDelete(String name) {
        ((RoutingRuleDAO)this.dao()).deleteByName(name);
    }

    private void postEvent(final RoutingRule rule) {
        this.eventManager.post((Object)new RoutingRuleInvalidatedEvent(){

            @Override
            public EntityId getRoutingRuleId() {
                return rule.id();
            }
        });
    }

    @VisibleForTesting
    static RoutingRule validate(RoutingRule rule) {
        ValidationErrorsException exception = new ValidationErrorsException();
        if (Strings2.isBlank((String)rule.name())) {
            exception.withError(NAME, "A non-empty value must be specified");
        } else if (!rule.name().matches("^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$")) {
            exception.withError(NAME, "Only letters, digits, underscores(_), hyphens(-), and dots(.) are allowed and may not start with underscore or dot.");
        } else if (rule.name().equalsIgnoreCase(NONE)) {
            exception.withError(NAME, "Rule must not be named None");
        }
        if (rule.description() == null) {
            exception.withError(DESCRIPTION, "A non-null value must be specified");
        }
        if (rule.mode() == null) {
            exception.withError(MODE, "A non-empty value must be specified");
        }
        if (rule.matchers() == null || rule.matchers().isEmpty()) {
            exception.withError(MATCHERS, "At least one rule must be specified");
        } else {
            int index = 0;
            for (String regex : rule.matchers()) {
                if (Strings2.isBlank((String)regex)) {
                    exception.withError("matchers[" + index + "]", "Empty matchers are not allowed");
                } else {
                    try {
                        Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException e) {
                        exception.withError("matchers[" + index + "]", "Invalid regex: " + e.getMessage());
                    }
                }
                ++index;
            }
        }
        if (!exception.getValidationErrors().isEmpty()) {
            throw exception;
        }
        return rule;
    }
}

