/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.routing;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleCreatedEvent;
import org.sonatype.nexus.repository.routing.RoutingRuleDeletedEvent;
import org.sonatype.nexus.repository.routing.RoutingRuleEvent;
import org.sonatype.nexus.repository.routing.RoutingRuleUpdatedEvent;

@Named
@Singleton
public class RoutingRuleAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "RoutingRule";

    public RoutingRuleAuditor() {
        this.registerType(RoutingRuleCreatedEvent.class, "created");
        this.registerType(RoutingRuleUpdatedEvent.class, "updated");
        this.registerType(RoutingRuleDeletedEvent.class, "deleted");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RoutingRuleEvent event) {
        if (this.isRecording()) {
            RoutingRule routingRule = event.getRoutingRule();
            AuditData data = this.getRoutingRuleAuditData(event, routingRule);
            this.record(data);
        }
    }

    private AuditData getRoutingRuleAuditData(RoutingRuleEvent event, RoutingRule routingRule) {
        AuditData data = new AuditData();
        data.setDomain(DOMAIN);
        data.setType(this.type(event.getClass()));
        data.setContext(routingRule.name());
        Map attributes = data.getAttributes();
        attributes.put("description", routingRule.description());
        attributes.put("mode", routingRule.mode());
        attributes.put("matchers", routingRule.matchers());
        return data;
    }
}

