/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.sonatype.nexus.blobstore.BlobStoreUtil;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class BlobStoreUtilImpl
implements BlobStoreUtil {
    private final RepositoryManager repositoryManager;

    @Inject
    public BlobStoreUtilImpl(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public int usageCount(String blobStoreId) {
        return Iterables.size(this.repositoryManager.browseForBlobStore(blobStoreId));
    }

    public boolean validateFilePath(String filePath, int maxLength) {
        Objects.requireNonNull(filePath);
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength should be greater than zero.");
        Path path = Paths.get(FilenameUtils.separatorsToSystem((String)filePath), new String[0]).toAbsolutePath();
        ArrayList<String> fileNames = new ArrayList<String>();
        Path pathParent = path.getParent();
        while (pathParent != null) {
            if (path.getFileName() != null) {
                fileNames.add(path.getFileName().toString());
            }
            path = pathParent;
            pathParent = path.getParent();
        }
        return !fileNames.stream().anyMatch(fileOrDirectory -> fileOrDirectory.length() > maxLength);
    }

    public Map<HashAlgorithm, HashCode> toHashObjects(Map<String, String> checksums) {
        return checksums.keySet().stream().map(HashAlgorithm::getHashAlgorithm).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Function.identity(), alg -> HashCode.fromString((String)((String)checksums.get(alg.name())))));
    }
}

