/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;

@Named(value="Blob Stores Ready")
@Singleton
public class BlobStoreStateHealthCheck
extends HealthCheck {
    private final Provider<BlobStoreManager> blobStoreManagerProvider;

    @Inject
    public BlobStoreStateHealthCheck(Provider<BlobStoreManager> blobStoreManagerProvider) {
        this.blobStoreManagerProvider = (Provider)Preconditions.checkNotNull(blobStoreManagerProvider);
    }

    protected HealthCheck.Result check() {
        List blobStores = StreamSupport.stream(((BlobStoreManager)this.blobStoreManagerProvider.get()).browse().spliterator(), false).map(blobStore -> {
            String name = blobStore.getBlobStoreConfiguration().getName();
            if (!blobStore.isStarted()) {
                return String.format("Blob store '%s' reports as not started", name);
            }
            if (!blobStore.getBlobStoreConfiguration().getType().equals("Group") && !blobStore.isWritable()) {
                return String.format("Blob store '%s' reports as not writeable", name);
            }
            if (!blobStore.isStorageAvailable()) {
                return String.format("Blob store '%s' reports as not available", name);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        String message = String.format("%s/%s blob stores report issues<br>%s", blobStores.size(), Iterators.size(((BlobStoreManager)this.blobStoreManagerProvider.get()).browse().iterator()), String.join((CharSequence)"<br>", blobStores));
        return blobStores.isEmpty() ? HealthCheck.Result.healthy((String)message) : HealthCheck.Result.unhealthy((String)message);
    }
}

