/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;

@Named(value="Blob Stores Quota")
@Singleton
public class BlobStoreQuotaHealthCheck
extends HealthCheck {
    private final Provider<BlobStoreManager> blobStoreManagerProvider;
    private final Provider<BlobStoreQuotaService> quotaServiceProvider;

    @Inject
    public BlobStoreQuotaHealthCheck(Provider<BlobStoreManager> blobStoreManagerProvider, Provider<BlobStoreQuotaService> quotaServiceProvider) {
        this.blobStoreManagerProvider = (Provider)Preconditions.checkNotNull(blobStoreManagerProvider);
        this.quotaServiceProvider = (Provider)Preconditions.checkNotNull(quotaServiceProvider);
    }

    protected HealthCheck.Result check() {
        Iterable blobstoreItr = ((BlobStoreManager)this.blobStoreManagerProvider.get()).browse();
        List violationMessages = StreamSupport.stream(blobstoreItr.spliterator(), false).map(blobStore -> ((BlobStoreQuotaService)this.quotaServiceProvider.get()).checkQuota(blobStore)).filter(Objects::nonNull).filter(BlobStoreQuotaResult::isViolation).map(BlobStoreQuotaResult::getMessage).collect(Collectors.toList());
        String message = String.format("%s/%s blob stores violating their quota<br>%s", violationMessages.size(), Iterators.size(((BlobStoreManager)this.blobStoreManagerProvider.get()).browse().iterator()), String.join((CharSequence)"<br>", violationMessages));
        return violationMessages.isEmpty() ? HealthCheck.Result.healthy((String)message) : HealthCheck.Result.unhealthy((String)message);
    }
}

