/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.blobstore.BlobStoreConfigurationStore;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreOverride;

@FeatureFlag(name="nexus.blobstore.override.enabled", enabledByDefault=true)
@Named
@Singleton
public class BlobStoreOverrideImpl
extends ComponentSupport
implements BlobStoreOverride {
    static final String NEXUS_BLOB_STORE_OVERRIDE = "NEXUS_BLOB_STORE_OVERRIDE";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Map<String, Map<String, Object>>>> TYPE_REFERENCE = new TypeReference<Map<String, Map<String, Map<String, Object>>>>(){};
    private final BlobStoreConfigurationStore blobStoreConfigurationStore;

    @Inject
    public BlobStoreOverrideImpl(BlobStoreConfigurationStore blobStoreConfigurationStore) {
        this.blobStoreConfigurationStore = (BlobStoreConfigurationStore)Preconditions.checkNotNull((Object)blobStoreConfigurationStore);
    }

    @Override
    public void apply() {
        String overrideJson = System.getenv(NEXUS_BLOB_STORE_OVERRIDE);
        if (Strings2.isBlank((String)overrideJson)) {
            return;
        }
        try {
            Map overrides = (Map)OBJECT_MAPPER.readValue(overrideJson, TYPE_REFERENCE);
            if (overrides == null) {
                this.log.warn("{} parsed to null: {}", (Object)NEXUS_BLOB_STORE_OVERRIDE, (Object)overrideJson);
                return;
            }
            List blobStoreConfigs = this.blobStoreConfigurationStore.list();
            this.log.debug("Applying blob store overrides: {}", (Object)overrides);
            blobStoreConfigs.stream().filter(config -> overrides.containsKey(config.getName())).forEach(config -> {
                Map changes = (Map)overrides.get(config.getName());
                if (changes != null && !changes.isEmpty()) {
                    this.log.debug("Merging changes into blob store {}: {}", (Object)config.getName(), (Object)changes);
                    if (this.mergeChangesToMap(changes, config.getAttributes())) {
                        this.blobStoreConfigurationStore.update(config);
                    }
                }
            });
        }
        catch (JsonProcessingException e) {
            this.log.error("Unable to parse {}: {}", (Object)NEXUS_BLOB_STORE_OVERRIDE, (Object)overrideJson);
            throw new IllegalStateException("Unable to parse environment variable NEXUS_BLOB_STORE_OVERRIDE", e);
        }
    }

    private boolean mergeChangesToMap(Map<String, Map<String, Object>> changes, Map<String, Map<String, Object>> map) {
        boolean changed = false;
        for (Map.Entry<String, Map<String, Object>> l1 : changes.entrySet()) {
            if (l1.getValue() == null) continue;
            for (Map.Entry<String, Object> l2 : l1.getValue().entrySet()) {
                Map<String, Object> l1Map = map.get(l1.getKey());
                if (l1Map == null || l2.getValue().equals(l1Map.get(l2.getKey()))) continue;
                l1Map.put(l2.getKey(), l2.getValue());
                changed = true;
            }
        }
        return changed;
    }
}

