/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.blobstore.BlobStoreConfigurationStore;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationData;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="blobStoreConfigurationExport")
@Singleton
public class BlobStoreConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final BlobStoreConfigurationStore configurationStore;

    @Inject
    public BlobStoreConfigurationExport(BlobStoreConfigurationStore configurationStore) {
        this.configurationStore = configurationStore;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export BlobStoreConfiguration data to {}", (Object)file);
        List configurations = this.configurationStore.list();
        this.exportToJson(configurations, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring BlobStoreConfiguration data from {}", (Object)file);
        this.importFromJson(file, BlobStoreConfigurationData.class).forEach(arg_0 -> ((BlobStoreConfigurationStore)this.configurationStore).create(arg_0));
    }
}

