/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreCreatedEvent;
import org.sonatype.nexus.blobstore.api.BlobStoreDeletedEvent;
import org.sonatype.nexus.blobstore.api.BlobStoreEvent;
import org.sonatype.nexus.blobstore.api.BlobStoreStartedEvent;
import org.sonatype.nexus.blobstore.api.BlobStoreStoppedEvent;
import org.sonatype.nexus.blobstore.api.BlobStoreUpdatedEvent;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
public class BlobStoreAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "blobstore";

    public BlobStoreAuditor() {
        this.registerType(BlobStoreCreatedEvent.class, "created");
        this.registerType(BlobStoreUpdatedEvent.class, "updated");
        this.registerType(BlobStoreDeletedEvent.class, "deleted");
        this.registerType(BlobStoreStartedEvent.class, "started");
        this.registerType(BlobStoreStoppedEvent.class, "stopped");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(BlobStoreEvent event) {
        if (this.isRecording()) {
            BlobStore blobStore = event.getBlobStore();
            BlobStoreConfiguration configuration = blobStore.getBlobStoreConfiguration();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(configuration.getName());
            Map attributes = data.getAttributes();
            attributes.put("name", configuration.getName());
            attributes.put("type", configuration.getType());
            this.record(data);
        }
    }
}

