/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.repository.config.internal.orient.OrientConfiguration;
import org.sonatype.nexus.repository.config.internal.orient.OrientConfigurationEntityAdapter;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientConfigurationStoreImpl
extends StateGuardLifecycleSupport
implements ConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientConfigurationStoreImpl(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Configuration> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void create(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)this.cast(configuration));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)this.cast(configuration));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)this.cast(configuration)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Collection<Configuration> readByNames(Set<String> repositoryNames) {
        return Collections.emptySet();
    }

    @Override
    public Configuration newConfiguration() {
        return new OrientConfiguration();
    }

    @Override
    public boolean exists(String repositoryName) {
        return false;
    }

    private OrientConfiguration cast(Configuration configuration) {
        return (OrientConfiguration)configuration;
    }
}

