/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal.orient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.collect.DetachingList;
import org.sonatype.nexus.common.collect.DetachingMap;
import org.sonatype.nexus.common.collect.DetachingSet;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.io.SanitizingJsonOutputStream;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.config.Configuration;

public class OrientConfiguration
extends AbstractEntity
implements Configuration {
    private static final TypeReference<Map<String, Map<String, Object>>> ATTRIBUTES_TYPE_REF = new TypeReference<Map<String, Map<String, Object>>>(){};
    private static final ObjectWriter ATTRIBUTES_JSON_WRITER = new ObjectMapper().writerFor(ATTRIBUTES_TYPE_REF);
    private static final ObjectReader ATTRIBUTES_JSON_READER = new ObjectMapper().readerFor(ATTRIBUTES_TYPE_REF);
    private Logger log = LoggerFactory.getLogger(OrientConfiguration.class);
    private String repositoryName;
    private String recipeName;
    private boolean online;
    private EntityId routingRuleId;
    private Map<String, Map<String, Object>> attributes;

    @Override
    public EntityId getRepositoryId() {
        return this.getEntityMetadata().getId();
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        this.repositoryName = (String)Preconditions.checkNotNull((Object)repositoryName);
    }

    @Override
    public String getRecipeName() {
        return this.recipeName;
    }

    @Override
    public void setRecipeName(String recipeName) {
        this.recipeName = (String)Preconditions.checkNotNull((Object)recipeName);
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void setOnline(boolean online) {
        this.online = online;
    }

    @Override
    public EntityId getRoutingRuleId() {
        return this.routingRuleId;
    }

    @Override
    public void setRoutingRuleId(EntityId routingRuleId) {
        this.routingRuleId = routingRuleId;
    }

    @Override
    @Nullable
    public Map<String, Map<String, Object>> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@Nullable Map<String, Map<String, Object>> attributes) {
        this.attributes = attributes;
    }

    @Override
    public NestedAttributesMap attributes(String key) {
        HashMap map;
        Preconditions.checkNotNull((Object)key);
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        if ((map = this.attributes.get(key)) == null) {
            map = Maps.newHashMap();
            this.attributes.put(key, map);
        }
        return new NestedAttributesMap(key, (Map)map);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "repositoryName='" + this.repositoryName + '\'' + ", recipeName='" + this.recipeName + '\'' + ", attributes=" + this.obfuscatedAttributes() + '}';
    }

    private String obfuscatedAttributes() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream obfuscatedAttrs = new ByteArrayOutputStream();){
                Throwable throwable2 = null;
                Object var5_9 = null;
                try (SanitizingJsonOutputStream sanitizer = new SanitizingJsonOutputStream((OutputStream)obfuscatedAttrs, (Collection)SENSITIVE_FIELD_NAMES, Strings2.mask((String)"password"));){
                    sanitizer.write(ATTRIBUTES_JSON_WRITER.writeValueAsBytes(this.attributes));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                Object result = ATTRIBUTES_JSON_READER.readValue(obfuscatedAttrs.toByteArray());
                String string = result != null ? result.toString() : "";
                return string;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Error obfuscating attributes", (Throwable)e);
            return String.format("<<Unable to obfuscate attributes. Exception was '%s'>>", e.getMessage());
        }
    }

    @Override
    public OrientConfiguration copy() {
        try {
            OrientConfiguration c = (OrientConfiguration)this.clone();
            c.attributes = this.copy(this.attributes);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private <V> V copy(V value) {
        Object copy = value;
        if (value instanceof Map) {
            copy = new DetachingMap((Map)value, this::copy);
        } else if (value instanceof List) {
            copy = new DetachingList((List)value, this::copy);
        } else if (value instanceof Set) {
            copy = new DetachingSet((Set)value, this::copy);
        }
        return copy;
    }
}

