/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventConsumer;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.ConfigurationCreatedEvent;
import org.sonatype.nexus.repository.config.ConfigurationDeletedEvent;
import org.sonatype.nexus.repository.config.ConfigurationEvent;
import org.sonatype.nexus.repository.config.ConfigurationUpdatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
public class ConfigurationSubscriber
extends ComponentSupport
implements EventAware {
    private final RepositoryManager repositoryManager;

    @Inject
    public ConfigurationSubscriber(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Subscribe
    public void on(ConfigurationCreatedEvent event) {
        this.handleReplication(event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> {
            Repository repository = this.repositoryManager.create(this.repositoryManager.retrieveConfigurationByName(e.getRepositoryName()).orElseThrow(() -> new RuntimeException("Missing configuration: " + e.getRepositoryName())));
        }));
    }

    @Subscribe
    public void on(ConfigurationUpdatedEvent event) {
        this.handleReplication(event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> {
            Repository repository = this.repositoryManager.update(this.repositoryManager.retrieveConfigurationByName(e.getRepositoryName()).orElseThrow(() -> new RuntimeException("Missing configuration: " + e.getRepositoryName())));
        }));
    }

    @Subscribe
    public void on(ConfigurationDeletedEvent event) {
        this.handleReplication(event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> this.repositoryManager.delete(e.getRepositoryName())));
    }

    private void handleReplication(ConfigurationEvent event, EventConsumer<ConfigurationEvent> consumer) {
        if (!event.isLocal()) {
            try {
                consumer.accept((Object)event);
            }
            catch (Exception e) {
                this.log.error("Failed to replicate: {}", (Object)event, (Object)e);
            }
        }
    }
}

