/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationDAO;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.repository.config.internal.ConfigurationCreatedEvent;
import org.sonatype.nexus.repository.config.internal.ConfigurationData;
import org.sonatype.nexus.repository.config.internal.ConfigurationDeletedEvent;
import org.sonatype.nexus.repository.config.internal.ConfigurationUpdatedEvent;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class ConfigurationStoreImpl
extends ConfigStoreSupport<ConfigurationDAO>
implements ConfigurationStore {
    @Inject
    public ConfigurationStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public Configuration newConfiguration() {
        return new ConfigurationData();
    }

    @Override
    @Transactional
    public List<Configuration> list() {
        return ImmutableList.copyOf((Iterable)((ConfigurationDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public void create(Configuration configuration) {
        this.postCommitEvent(() -> new ConfigurationCreatedEvent((ConfigurationData)configuration));
        ((ConfigurationDAO)this.dao()).create((ConfigurationData)configuration);
        ((ConfigurationDAO)this.dao()).read(configuration.getRepositoryId()).ifPresent(persisted -> configuration.setAttributes(persisted.getAttributes()));
    }

    @Override
    @Transactional
    public void update(Configuration configuration) {
        this.postCommitEvent(() -> new ConfigurationUpdatedEvent((ConfigurationData)configuration));
        ((ConfigurationDAO)this.dao()).update((ConfigurationData)configuration);
        ((ConfigurationDAO)this.dao()).read(configuration.getRepositoryId()).ifPresent(persisted -> configuration.setAttributes(persisted.getAttributes()));
    }

    @Override
    @Transactional
    public void delete(Configuration configuration) {
        this.postCommitEvent(() -> new ConfigurationDeletedEvent((ConfigurationData)configuration));
        ((ConfigurationDAO)this.dao()).deleteByName(configuration.getRepositoryName());
    }

    @Override
    @Transactional
    public Collection<Configuration> readByNames(Set<String> repositoryNames) {
        return Optional.ofNullable(repositoryNames).filter(CollectionUtils::isNotEmpty).map(names -> ((ConfigurationDAO)this.dao()).readByNames((Set<String>)names)).orElse(Collections.emptyList());
    }

    @Override
    @Transactional
    public boolean exists(String repositoryName) {
        return ((ConfigurationDAO)this.dao()).readByName(repositoryName).isPresent();
    }
}

