/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.config.ConfigurationObjectMapperCustomizer;

@Named(value="repository-configuration")
@Singleton
public class ConfigurationObjectMapperProvider
extends ComponentSupport
implements Provider<ObjectMapper> {
    public static final String NAME = "repository-configuration";
    private final Map<String, ConfigurationObjectMapperCustomizer> customizers;

    @Inject
    public ConfigurationObjectMapperProvider(Map<String, ConfigurationObjectMapperCustomizer> customizers) {
        this.customizers = (Map)Preconditions.checkNotNull(customizers);
    }

    public ObjectMapper get() {
        ObjectMapper mapper = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (ConfigurationObjectMapperCustomizer customizer : this.customizers.values()) {
            customizer.customize(mapper);
        }
        return mapper;
    }
}

