/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.validation.ConstraintViolations;

@Named
public class ConfigurationFacetImpl
extends FacetSupport
implements ConfigurationFacet {
    private final ConfigurationStore store;
    private final ObjectMapper objectMapper;
    private final Provider<Validator> validatorProvider;

    @Inject
    public ConfigurationFacetImpl(ConfigurationStore store, @Named(value="repository-configuration") @Named(value="repository-configuration") ObjectMapper objectMapper, Provider<Validator> validatorProvider) {
        this.store = (ConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.validatorProvider = (Provider)Preconditions.checkNotNull(validatorProvider);
    }

    @Override
    public void save() throws Exception {
        this.store.update(this.getRepository().getConfiguration());
        this.log.debug("Saved");
    }

    @Override
    public <T> T convert(Object value, Class<T> type) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(type);
        this.log.trace("Converting value: {} to type: {}", value, type);
        return (T)this.objectMapper.convertValue(value, type);
    }

    @Override
    public <T> T readSection(Configuration configuration, String section, Class<T> type) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)section);
        this.log.trace("Reading section: {}", (Object)section);
        NestedAttributesMap attributes = configuration.attributes(section);
        return this.convert(attributes.backing(), type);
    }

    @Override
    public void validate(Object value, Class<?> ... groups) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(groups);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Validating: {} in groups: {}", value, Arrays.asList(groups));
        }
        Validator validator = (Validator)this.validatorProvider.get();
        Set violations = validator.validate(value, (Class[])groups);
        ConstraintViolations.maybePropagate((Set)violations, (Logger)this.log);
    }

    @Override
    public <T> T validateSection(Configuration configuration, String section, Class<T> type, Class<?> ... groups) {
        T value = this.readSection(configuration, section, type);
        SectionWrapper wrapper = new SectionWrapper(section, value);
        this.validate(wrapper, groups);
        return value;
    }

    private static class SectionWrapper {
        @Valid
        private Map<String, Object> attributes;

        public SectionWrapper(String name, Object value) {
            this.attributes = Collections.singletonMap(name, value);
        }
    }
}

