/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.DetachingList;
import org.sonatype.nexus.common.collect.DetachingMap;
import org.sonatype.nexus.common.collect.DetachingSet;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.HasEntityId;
import org.sonatype.nexus.common.entity.HasName;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.supportzip.PasswordSanitizing;

public class ConfigurationData
implements HasEntityId,
HasName,
Configuration {
    private static final PasswordSanitizing<Map<String, Map<String, Object>>> SANITIZING = new PasswordSanitizing();
    @JsonIgnore
    private EntityId id;
    private String name;
    private String recipeName;
    private boolean online;
    private EntityId routingRuleId;
    private Map<String, Map<String, Object>> attributes;

    public EntityId getId() {
        return this.id;
    }

    public void setId(EntityId id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public EntityId getRepositoryId() {
        return this.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getRepositoryName() {
        return this.getName();
    }

    @Override
    public void setRepositoryName(String name) {
        this.setName(name);
    }

    @Override
    public String getRecipeName() {
        return this.recipeName;
    }

    @Override
    public void setRecipeName(String recipeName) {
        this.recipeName = (String)Preconditions.checkNotNull((Object)recipeName);
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void setOnline(boolean online) {
        this.online = online;
    }

    @Override
    public EntityId getRoutingRuleId() {
        return this.routingRuleId;
    }

    @Override
    public void setRoutingRuleId(EntityId routingRuleId) {
        this.routingRuleId = routingRuleId;
    }

    @Override
    @Nullable
    public Map<String, Map<String, Object>> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@Nullable Map<String, Map<String, Object>> attributes) {
        this.attributes = attributes;
    }

    @Override
    public NestedAttributesMap attributes(String key) {
        Preconditions.checkNotNull((Object)key);
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        Map map = this.attributes.computeIfAbsent(key, k -> Maps.newHashMap());
        return new NestedAttributesMap(key, map);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "repositoryName='" + this.name + '\'' + ", recipeName='" + this.recipeName + '\'' + ", attributes=" + SANITIZING.transform(this.attributes) + '}';
    }

    @Override
    public ConfigurationData copy() {
        try {
            ConfigurationData c = (ConfigurationData)this.clone();
            c.id = null;
            c.attributes = this.copy(this.attributes);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private <V> V copy(V value) {
        Object copy = value;
        if (value instanceof Map) {
            copy = new DetachingMap((Map)value, this::copy);
        } else if (value instanceof List) {
            copy = new DetachingList((List)value, this::copy);
        } else if (value instanceof Set) {
            copy = new DetachingSet((Set)value, this::copy);
        }
        return copy;
    }
}

