/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.config.Configuration;

public class SimpleConfiguration
implements Configuration {
    private EntityId repositoryId;
    private String repositoryName;
    private String recipeName;
    private boolean online;
    private EntityId routingRuleId = null;
    private Map<String, Map<String, Object>> attributes;

    public SimpleConfiguration() {
    }

    public SimpleConfiguration(EntityId repositoryId, String repositoryName, String recipeName, boolean online, EntityId routingRuleId, Map<String, Map<String, Object>> attributes) {
        this.repositoryId = repositoryId;
        this.repositoryName = repositoryName;
        this.recipeName = recipeName;
        this.online = online;
        this.routingRuleId = routingRuleId;
        this.attributes = attributes;
    }

    @Override
    public EntityId getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(EntityId repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public String getRecipeName() {
        return this.recipeName;
    }

    @Override
    public void setRecipeName(String recipeName) {
        this.recipeName = recipeName;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void setOnline(boolean online) {
        this.online = online;
    }

    @Override
    public EntityId getRoutingRuleId() {
        return this.routingRuleId;
    }

    @Override
    public void setRoutingRuleId(EntityId routingRuleId) {
        this.routingRuleId = routingRuleId;
    }

    @Override
    @Nullable
    public Map<String, Map<String, Object>> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@Nullable Map<String, Map<String, Object>> attributes) {
        this.attributes = attributes;
    }

    @Override
    public NestedAttributesMap attributes(String key) {
        HashMap map;
        Preconditions.checkNotNull((Object)key);
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        if ((map = this.attributes.get(key)) == null) {
            map = Maps.newHashMap();
            this.attributes.put(key, map);
        }
        return new NestedAttributesMap(key, (Map)map);
    }

    @Override
    public Configuration copy() {
        return this;
    }
}

