/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config;

import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.RepositoryTypeHosted;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
public class RepositoryTypeHostedValidator
extends ConstraintValidatorSupport<RepositoryTypeHosted, String> {
    @Inject
    private RepositoryManager repositoryManager;

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (!Strings2.isBlank((String)value)) {
            Repository repository = this.repositoryManager.get(value);
            if (repository != null) {
                return repository.getType().getValue().equals("hosted");
            }
            return false;
        }
        return true;
    }
}

