/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.repository.BrowseUnsupportedHandler;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.HighAvailabilitySupportChecker;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.recipe.RouterBuilder;

public abstract class RecipeSupport
extends ComponentSupport
implements Recipe {
    private final Format format;
    private final Type type;
    private BrowseUnsupportedHandler browseUnsupportedHandler;
    private HighAvailabilitySupportChecker highAvailabilitySupportChecker;
    private DatabaseCheck databaseCheck;

    protected RecipeSupport(Type type, Format format) {
        this.type = (Type)Preconditions.checkNotNull((Object)type);
        this.format = (Format)Preconditions.checkNotNull((Object)format);
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "format=" + this.format + ", type=" + this.type + '}';
    }

    @Inject
    public void setHighAvailabilitySupportChecker(HighAvailabilitySupportChecker highAvailabilitySupportChecker) {
        this.highAvailabilitySupportChecker = highAvailabilitySupportChecker;
    }

    @Inject
    public void setBrowseUnsupportedHandler(BrowseUnsupportedHandler browseUnsupportedHandler) {
        this.browseUnsupportedHandler = (BrowseUnsupportedHandler)Preconditions.checkNotNull((Object)browseUnsupportedHandler);
    }

    @Inject
    public void setDatabaseCheck(DatabaseCheck databaseCheck) {
        this.databaseCheck = databaseCheck;
    }

    protected void addBrowseUnsupportedRoute(RouterBuilder builder) {
        builder.route(this.browseUnsupportedHandler.getRoute());
    }

    @Override
    public boolean isFeatureEnabled() {
        if (this.databaseCheck != null && !this.databaseCheck.isAllowedByVersion(this.getClass())) {
            return false;
        }
        if (this.highAvailabilitySupportChecker != null) {
            return this.highAvailabilitySupportChecker.isSupported(this.getFormat().getValue());
        }
        this.log.error("HighAvailabilitySupportChecker not found - Format {} will not be enabled", (Object)this.getFormat());
        return false;
    }
}

