/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;

public abstract class HighAvailabilitySupportChecker {
    private final boolean isNexusClustered;
    private final Map<String, Boolean> formatHAStates = new ConcurrentHashMap<String, Boolean>();

    public HighAvailabilitySupportChecker(NodeAccess nodeAccess) {
        this.isNexusClustered = nodeAccess.isClustered();
        this.getEnabledFormats().forEach(format -> {
            Boolean bl = this.formatHAStates.put((String)format, this.queryFormat((String)format, true));
        });
    }

    protected abstract List<String> getEnabledFormats();

    public boolean isSupported(String formatName) {
        boolean formatEnabled = this.formatHAStates.computeIfAbsent(formatName, f -> this.queryFormat(formatName, false));
        return !this.isNexusClustered || formatEnabled;
    }

    private boolean queryFormat(String formatName, boolean defaultValue) {
        return SystemPropertiesHelper.getBoolean((String)String.format("nexus.%s.ha.supported", formatName), (boolean)defaultValue);
    }
}

