/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.upgrades;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class SoftDeletedBlobsMigrationStep_1_19
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String CREATE_INDEX = "ALTER TABLE soft_deleted_blobs ADD CONSTRAINT pk_soft_deleted_blobs_record_id PRIMARY KEY (record_id)";
    private static final String DROP_INDEX = "ALTER TABLE soft_deleted_blobs DROP CONSTRAINT IF EXISTS pk_soft_deleted_blobs_blob_id";
    private static final String H2 = "SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = 'SOFT_DELETED_BLOBS' AND CONSTRAINT_NAME = 'PK_SOFT_DELETED_BLOBS_BLOB_ID'";
    private static final String PSQL = "SELECT * FROM information_schema.table_constraints WHERE table_name = 'soft_deleted_blobs' AND constraint_name = 'pk_soft_deleted_blobs_blob_id'";

    public Optional<String> version() {
        return Optional.of("1.19");
    }

    public void migrate(Connection connection) throws Exception {
        if (this.tableExists(connection, "soft_deleted_blobs") && this.isPKConstraintOutdated(connection)) {
            this.runStatement(connection, DROP_INDEX);
            this.runStatement(connection, CREATE_INDEX);
            this.log.info("PK for table 'soft_deleted_blobs' has changed from 'blob_id' to 'record_id'");
        }
    }

    private boolean isPKConstraintOutdated(Connection connection) throws SQLException {
        String oldConstraintPresentCheckQuery;
        if (this.isH2(connection)) {
            oldConstraintPresentCheckQuery = H2;
        } else if (this.isPostgresql(connection)) {
            oldConstraintPresentCheckQuery = PSQL;
        } else {
            throw new SQLException("Unexpected DB engine type");
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement stmt = connection.prepareStatement(oldConstraintPresentCheckQuery);){
            return stmt.executeQuery().next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

