/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import org.sonatype.nexus.blobstore.file.rest.FileBlobStoreApiCreateRequest;
import org.sonatype.nexus.blobstore.file.rest.FileBlobStoreApiModel;
import org.sonatype.nexus.blobstore.file.rest.FileBlobStoreApiUpdateRequest;
import org.sonatype.nexus.validation.Validate;

@Api(value="Blob store")
public interface FileBlobStoreResourceDoc {
    @ApiOperation(value="Create a file blob store")
    @ApiResponses(value={@ApiResponse(code=204, message="Success"), @ApiResponse(code=403, message="Insufficient permissions")})
    public void createFileBlobStore(@Valid FileBlobStoreApiCreateRequest var1) throws Exception;

    @ApiOperation(value="Update a file blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=204, message="Success"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Blob store not found")})
    @Validate
    public void updateFileBlobStore(@ApiParam(value="The name of the file blob store to update") String var1, @Valid FileBlobStoreApiUpdateRequest var2) throws Exception;

    @ApiOperation(value="Get a file blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=FileBlobStoreApiModel.class), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Blob store not found")})
    public FileBlobStoreApiModel getFileBlobStoreConfiguration(@ApiParam(value="The name of the file blob store to read", example="default") String var1);
}

