/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal.datastore.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.BlobStoreMetricsPropertiesReaderSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.file.FileBlobStore;
import org.sonatype.nexus.common.property.PropertiesFile;

@Named(value="File")
@Singleton
public class FileBlobStoreMetricsPropertiesReader
extends BlobStoreMetricsPropertiesReaderSupport<PropertiesFile> {
    private Path storageDir;

    public void initWithBlobStore(BlobStore blobStore) throws Exception {
        if (!(blobStore instanceof FileBlobStore)) {
            throw new IllegalArgumentException("BlobStore must be of type FileBlobStore");
        }
        this.storageDir = ((FileBlobStore)blobStore).getAbsoluteBlobDir();
    }

    protected PropertiesFile getProperties() throws Exception {
        return this.loadProperties(this.storageDir);
    }

    protected Map<String, Long> getAvailableSpace() throws Exception {
        FileStore fileStore = Files.getFileStore(this.storageDir);
        return ImmutableMap.of((Object)("fileStore:" + fileStore.name()), (Object)fileStore.getUsableSpace());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private PropertiesFile loadProperties(Path storageDir) throws Exception {
        Preconditions.checkNotNull((Object)storageDir);
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> files = Files.newDirectoryStream(storageDir, path -> path.toString().endsWith(this.metricsFilename()));){
            Optional<PropertiesFile> propertiesFile = StreamSupport.stream(files.spliterator(), false).collect(Collectors.toList()).stream().map(Path::toFile).map(PropertiesFile::new).findFirst();
            if (!propertiesFile.isPresent()) {
                return null;
            }
            propertiesFile.get().load();
            return propertiesFile.get();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

