/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal.datastore;

import com.google.common.base.Preconditions;
import com.squareup.tape.QueueFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.file.FileBlobDeletionIndex;
import org.sonatype.nexus.blobstore.file.FileBlobStore;
import org.sonatype.nexus.blobstore.file.store.SoftDeletedBlobsData;
import org.sonatype.nexus.blobstore.file.store.SoftDeletedBlobsStore;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.PropertiesFile;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
public class DatastoreFileBlobDeletionIndex
extends ComponentSupport
implements FileBlobDeletionIndex {
    private static final int INTERVAL_IN_SECONDS = 60;
    private final SoftDeletedBlobsStore softDeletedBlobsStore;
    private final PeriodicJobService periodicJobService;
    private final Duration migrationDelay;
    private FileBlobStore blobStore;
    private String blobStoreName;
    private Deque<String> deletedRecordsCache;

    @Inject
    public DatastoreFileBlobDeletionIndex(SoftDeletedBlobsStore softDeletedBlobsStore, PeriodicJobService periodicJobService, @Named(value="${nexus.file.deletion.migrate.delay:-60s}") @Named(value="${nexus.file.deletion.migrate.delay:-60s}") Duration migrationDelay) {
        this.softDeletedBlobsStore = (SoftDeletedBlobsStore)Preconditions.checkNotNull((Object)softDeletedBlobsStore);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.migrationDelay = (Duration)Preconditions.checkNotNull((Object)migrationDelay);
        Preconditions.checkArgument((!migrationDelay.isNegative() ? 1 : 0) != 0, (Object)"Non-negative nexus.file.deletion.migrate.delay required");
    }

    @Override
    public final void initIndex(PropertiesFile metadata, FileBlobStore blobStore) throws IOException {
        this.blobStore = blobStore;
        this.blobStoreName = blobStore.getBlobStoreConfiguration().getName();
        this.scheduleMigrateIndex(metadata);
        this.deletedRecordsCache = new ArrayDeque<String>();
    }

    @Override
    public void stopIndex() throws IOException {
    }

    @Override
    public final void createRecord(BlobId blobId) {
        this.softDeletedBlobsStore.createRecord(blobId, this.blobStoreName);
    }

    private void populateInternalCache() {
        this.deletedRecordsCache.addAll(this.softDeletedBlobsStore.readOldestRecords(this.blobStoreName));
    }

    @Override
    public final String readOldestRecord() {
        if (this.deletedRecordsCache.isEmpty()) {
            this.populateInternalCache();
        }
        return this.deletedRecordsCache.pollFirst();
    }

    @Override
    public final void deleteRecord(BlobId blobId) {
        this.deletedRecordsCache.remove(blobId.asUniqueString());
        this.softDeletedBlobsStore.deleteRecord(this.blobStoreName, blobId);
    }

    @Override
    public final void deleteAllRecords() {
        this.softDeletedBlobsStore.deleteAllRecords(this.blobStoreName);
    }

    @Override
    public final int size() throws IOException {
        return this.softDeletedBlobsStore.count(this.blobStoreName);
    }

    private void scheduleMigrateIndex(PropertiesFile metadata) {
        this.invoke(() -> ((PeriodicJobService)this.periodicJobService).startUsing());
        this.periodicJobService.runOnce(() -> {
            try {
                this.migrateDeletionIndexFromFiles(metadata);
            }
            catch (IOException e) {
                this.log.error("Failed to migrate soft deleted blobs to the database", (Throwable)e);
            }
            this.invoke(() -> ((PeriodicJobService)this.periodicJobService).stopUsing());
        }, (int)this.migrationDelay.getSeconds());
    }

    private void migrateDeletionIndexFromFiles(PropertiesFile metadata) throws IOException {
        this.blobStore.getDeletionIndexFiles().forEach(deletionIndexFile -> {
            try {
                this.migrateDeletionIndexFromFile(metadata, (File)deletionIndexFile);
            }
            catch (IOException iOException) {
                this.log.error("An error occurred while attempting to migrate the deletions index {} for {}", deletionIndexFile, (Object)this.blobStoreName);
            }
        });
    }

    private void migrateDeletionIndexFromFile(PropertiesFile metadata, @Nullable File oldDeletionIndexFile) throws IOException {
        QueueFile oldDeletionIndex;
        this.log.debug("Starting migration in {} for {}", (Object)this.blobStoreName, (Object)oldDeletionIndexFile);
        try {
            oldDeletionIndex = new QueueFile(oldDeletionIndexFile);
        }
        catch (IOException e) {
            this.log.error("Unable to load deletions index file {}, run the compact blobstore task to rebuild", (Object)oldDeletionIndexFile, (Object)e);
            oldDeletionIndex = null;
            metadata.setProperty("rebuildDeletedBlobIndex", "true");
            metadata.store();
        }
        if (Objects.nonNull(oldDeletionIndex) && !oldDeletionIndex.isEmpty()) {
            this.log.info("Processing blobstore {}, discovered file-based deletion index. Migrating to DB-based", (Object)this.blobStore.getBlobStoreConfiguration().getName());
            Set<String> persistedRecords = this.getPersistedBlobIdsForBlobStore(this.blobStoreName);
            Throwable throwable = null;
            Object var6_8 = null;
            try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
                int counter = 0;
                int numBlobs = oldDeletionIndex.size();
                while (counter < numBlobs) {
                    byte[] bytes = oldDeletionIndex.peek();
                    if (bytes == null) {
                        this.log.debug("Queue indicated no more results {} of {}", (Object)counter, (Object)numBlobs);
                        break;
                    }
                    BlobId blobId = new BlobId(new String(bytes, StandardCharsets.UTF_8));
                    if (!persistedRecords.contains(blobId.toString())) {
                        this.softDeletedBlobsStore.createRecord(blobId, this.blobStore.getBlobStoreConfiguration().getName());
                        persistedRecords.add(blobId.toString());
                    } else {
                        this.log.debug("Old deletion index contain duplicate entry with blobId - {} for blobstore - {}, duplicate record will be skipped", (Object)blobId, (Object)this.blobStoreName);
                    }
                    oldDeletionIndex.remove();
                    progressLogger.info("Elapsed time: {}, processed: {}/{}", new Object[]{progressLogger.getElapsed(), counter + 1, numBlobs});
                    ++counter;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (oldDeletionIndexFile.exists() && !oldDeletionIndexFile.delete()) {
            this.log.error("Unable to delete 'deletion index' file, path = {}", (Object)oldDeletionIndexFile.getAbsolutePath());
        }
    }

    private Set<String> getPersistedBlobIdsForBlobStore(String blobStoreName) {
        HashSet<String> persistedRecords = new HashSet<String>();
        Continuation<SoftDeletedBlobsData> page = this.softDeletedBlobsStore.readRecords(null, blobStoreName);
        while (!page.isEmpty()) {
            persistedRecords.addAll(page.stream().map(SoftDeletedBlobsData::getBlobId).collect(Collectors.toSet()));
            page = this.softDeletedBlobsStore.readRecords(page.nextContinuationToken(), blobStoreName);
        }
        return persistedRecords;
    }

    private void invoke(ThrowingRunnable callable) {
        try {
            callable.run();
        }
        catch (Exception e) {
            this.log.debug("Failed to start or stop using the PeriodicJobService", (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

