/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.file.store.SoftDeletedBlobsData;
import org.sonatype.nexus.blobstore.file.store.SoftDeletedBlobsStore;
import org.sonatype.nexus.blobstore.file.store.internal.SoftDeletedBlobsDAO;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class SoftDeletedBlobsStoreImpl
extends ConfigStoreSupport<SoftDeletedBlobsDAO>
implements SoftDeletedBlobsStore {
    @Inject
    public SoftDeletedBlobsStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    @Transactional
    public void createRecord(BlobId blobId, String sourceBlobStoreName) {
        ((SoftDeletedBlobsDAO)this.dao()).createRecord(sourceBlobStoreName, blobId.toString());
    }

    @Override
    @Transactional
    public Continuation<SoftDeletedBlobsData> readRecords(String continuationToken, String sourceBlobStoreName) {
        return ((SoftDeletedBlobsDAO)this.dao()).readRecords(continuationToken, sourceBlobStoreName);
    }

    @Override
    @Transactional
    public void deleteRecord(String sourceBlobStoreName, BlobId blobId) {
        ((SoftDeletedBlobsDAO)this.dao()).deleteRecord(sourceBlobStoreName, blobId.toString());
    }

    @Override
    public void deleteAllRecords(String sourceBlobStoreName) {
        while (this.doDeleteAllBlobs(sourceBlobStoreName) != 0) {
        }
    }

    @Transactional
    public int doDeleteAllBlobs(String sourceBlobName) {
        return ((SoftDeletedBlobsDAO)this.dao()).deleteAllRecords(sourceBlobName, "1000");
    }

    @Override
    @Transactional
    public int count(String sourceBlobStoreName) {
        return ((SoftDeletedBlobsDAO)this.dao()).count(sourceBlobStoreName);
    }

    @Override
    @Transactional
    public List<String> readOldestRecords(String sourceBlobStoreName) {
        return ((SoftDeletedBlobsDAO)this.dao()).readOldestRecords(sourceBlobStoreName);
    }
}

