/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorSupport;
import org.sonatype.nexus.blobstore.BlobStoreUtil;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.file.internal.FileBlobStorePathValidator;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.rest.ValidationErrorsException;

@AvailabilityVersion(from="1.0")
@Named(value="File")
public class FileBlobStoreDescriptor
extends BlobStoreDescriptorSupport {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final ApplicationDirectories applicationDirectories;
    private final FormField<String> path;
    private final BlobStoreUtil blobStoreUtil;
    private final FileBlobStorePathValidator pathValidator;

    @Inject
    public FileBlobStoreDescriptor(BlobStoreQuotaService quotaService, ApplicationDirectories applicationDirectories, BlobStoreUtil blobStoreUtil, FileBlobStorePathValidator pathValidator) {
        super(quotaService);
        this.applicationDirectories = applicationDirectories;
        this.blobStoreUtil = blobStoreUtil;
        this.pathValidator = pathValidator;
        this.path = new StringTextFormField("path", messages.pathLabel(), messages.pathHelpText(), true).withAttribute("tokenReplacement", (Object)(applicationDirectories.getWorkDirectory("blobs") + "/${name}")).withAttribute("long", (Object)Boolean.TRUE);
    }

    public String getId() {
        return "file";
    }

    public String getName() {
        return messages.name();
    }

    public List<FormField> getFormFields() {
        return Arrays.asList(this.path);
    }

    public void validateConfig(BlobStoreConfiguration config) {
        super.validateConfig(config);
        Path path = Optional.ofNullable((String)config.attributes("file").get("path", String.class)).filter(s -> this.blobStoreUtil.validateFilePath(s, 255)).map(s -> Paths.get(s, new String[0])).orElseThrow(() -> new ValidationErrorsException(String.format("The maximum name length for any folder in the path is %d.", 255)));
        this.pathValidator.validatePathUniqueConstraint(config);
        try {
            if (!path.isAbsolute()) {
                Path baseDir = this.applicationDirectories.getWorkDirectory("blobs").toPath().toRealPath(new LinkOption[0]).normalize();
                path = baseDir.resolve(path.normalize());
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                throw new ValidationErrorsException(String.format("Blob store could not be written to path '%s' because it is a file not a directory", path));
            }
        }
        catch (IOException e) {
            throw new ValidationErrorsException(String.format("Blob store could not be written because the path %s could not be written to", path), (Throwable)e);
        }
        if (!Files.isWritable(path)) {
            throw new ValidationErrorsException(String.format("Blob store could not be written to path '%s' because it was not writable", path));
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="File")
        public String name();

        @MessageBundle.DefaultMessage(value="Path")
        public String pathLabel();

        @MessageBundle.DefaultMessage(value="An absolute path or a path relative to <data-directory>/blobs")
        public String pathHelpText();
    }
}

