/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;

public class FileRawObjectAccess
extends ComponentSupport
implements RawObjectAccess {
    private final Path storageDir;

    public FileRawObjectAccess(Path storageDir) {
        this.storageDir = Objects.requireNonNull(storageDir);
    }

    public Stream<String> listRawObjects(@Nullable Path path) {
        try {
            Path dir = path != null ? this.storageDir.resolve(path) : this.storageDir;
            return this.listFiles(dir, File::isFile).map(File::getName);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public InputStream getRawObject(Path path) {
        try {
            File rawObjectFile = this.storageDir.resolve(path).toFile();
            if (rawObjectFile.exists()) {
                return new FileInputStream(rawObjectFile);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putRawObject(Path path, InputStream input) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = input;){
                File rawObjectFile = this.storageDir.resolve(path).toFile();
                FileUtils.copyToFile((InputStream)in, (File)rawObjectFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Stream<File> listFiles(Path dirPath, FileFilter fileFilter) throws IOException {
        File dir = dirPath.toFile();
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(fileFilter);
            if (files != null) {
                return Arrays.stream(files).sorted();
            }
            throw new IOException("Unexpected exception reading directory " + dir);
        }
        this.log.debug("Path {} is not a directory", (Object)dirPath);
        return Stream.empty();
    }

    public void deleteRawObject(Path path) {
        try {
            File rawObjectFile = this.storageDir.resolve(path).toFile();
            if (rawObjectFile.exists()) {
                Files.delete(rawObjectFile.toPath());
                this.deleteEmptyParentDirectories(rawObjectFile.getParentFile());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void deleteRawObjectsInPath(Path path) {
        try {
            File rawObjectDir = this.storageDir.resolve(path).toFile();
            if (rawObjectDir.exists()) {
                File[] files = rawObjectDir.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.isFile()) {
                            Files.delete(file.toPath());
                        }
                        ++n2;
                    }
                }
                this.deleteEmptyParentDirectories(rawObjectDir);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean hasRawObject(Path path) {
        File rawObjectFile = this.storageDir.resolve(path).toFile();
        return rawObjectFile.exists();
    }

    private void deleteEmptyParentDirectories(File dir) throws IOException {
        File parent = dir.getParentFile();
        String[] children = dir.list();
        if (children == null || children.length == 0) {
            Files.delete(dir.toPath());
            this.deleteEmptyParentDirectories(parent);
        }
    }
}

