/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.jdbc.JdbcUrlRedactor;

public class DataStoreConfiguration {
    public static final String REDACTED = "**REDACTED**";
    private static final String JDBC_URL = "jdbcUrl";
    private static final Predicate<String> SENSITIVE_KEYS = Pattern.compile("(?i)(auth|cred|key|pass|secret|sign|token)").asPredicate();
    private String name;
    private String type;
    private String source;
    private Map<String, String> attributes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = (String)Preconditions.checkNotNull((Object)source);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = (Map)Preconditions.checkNotNull(attributes);
    }

    public static boolean isSensitiveKey(String key) {
        return SENSITIVE_KEYS.test(key);
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", source='" + this.source + '\'' + ", attributes=" + this.maybeRedact(this.attributes) + '}';
    }

    public static Map<String, Map<String, String>> diff(DataStoreConfiguration left, DataStoreConfiguration right) {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        DataStoreConfiguration.diff("name", left, right, DataStoreConfiguration::getName, results);
        DataStoreConfiguration.diff("source", left, right, DataStoreConfiguration::getSource, results);
        DataStoreConfiguration.diff("type", left, right, DataStoreConfiguration::getType, results);
        Stream.concat(left.getAttributes().keySet().stream(), right.getAttributes().keySet().stream()).distinct().forEach(attributeKey -> {
            Function<DataStoreConfiguration, String> getAttribute = config -> config.getAttributes().getOrDefault(attributeKey, null);
            DataStoreConfiguration.diff("attributes->" + attributeKey, left, right, getAttribute, results);
        });
        return results;
    }

    private static void diff(String fieldName, DataStoreConfiguration a, DataStoreConfiguration b, Function<DataStoreConfiguration, String> fieldFunction, Map<String, Map<String, String>> results) {
        String bField;
        String aField = fieldFunction.apply(a);
        if (!Objects.equals(aField, bField = fieldFunction.apply(b))) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(a.getName(), DataStoreConfiguration.maybeRedact(fieldName, aField));
            result.put(b.getName(), DataStoreConfiguration.maybeRedact(fieldName, bField));
            results.put(fieldName, result);
        }
    }

    protected Map<String, String> maybeRedact(Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return attributes;
        }
        return Maps.transformEntries(attributes, DataStoreConfiguration::maybeRedact);
    }

    private static String maybeRedact(String key, String value) {
        String result = value;
        if (StringUtils.containsIgnoreCase((String)key, (String)JDBC_URL)) {
            result = JdbcUrlRedactor.redactPassword((String)value);
        }
        return DataStoreConfiguration.isSensitiveKey(key) ? REDACTED : result;
    }
}

