/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.mime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class MimeRule {
    private final boolean override;
    private final List<String> mimetypes;

    public MimeRule(boolean override, String ... mimetypes) {
        this(override, Arrays.asList(mimetypes));
    }

    public MimeRule(boolean override, List<String> mimetypes) {
        Preconditions.checkNotNull(mimetypes, (Object)"mimetypes");
        Preconditions.checkArgument((!mimetypes.isEmpty() ? 1 : 0) != 0, (Object)"mimetypes");
        this.override = override;
        this.mimetypes = ImmutableList.copyOf(mimetypes);
    }

    public boolean isOverride() {
        return this.override;
    }

    @Nonnull
    public List<String> getMimetypes() {
        return this.mimetypes;
    }
}

