/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.sonatype.nexus.transaction.TransactionIsolation;
import org.sonatype.nexus.transaction.Transactional;

final class TransactionalImpl
implements Transactional {
    private final String reason;
    private final Class[] commitOn;
    private final Class[] retryOn;
    private final Class[] swallow;
    private final TransactionIsolation isolation;

    TransactionalImpl(String reason, Class[] commitOn, Class[] retryOn, Class[] swallow, TransactionIsolation isolation) {
        this.reason = reason;
        this.commitOn = commitOn;
        this.retryOn = retryOn;
        this.swallow = swallow;
        this.isolation = isolation;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Transactional.class;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public Class<? extends Exception>[] commitOn() {
        return this.commitOn;
    }

    @Override
    public Class<? extends Exception>[] retryOn() {
        return this.retryOn;
    }

    @Override
    public Class<? extends Exception>[] swallow() {
        return this.swallow;
    }

    @Override
    public TransactionIsolation isolation() {
        return this.isolation;
    }

    @Override
    public int hashCode() {
        return (127 * "reason".hashCode() ^ this.reason.hashCode()) + (127 * "commitOn".hashCode() ^ Arrays.hashCode(this.commitOn)) + (127 * "retryOn".hashCode() ^ Arrays.hashCode(this.retryOn)) + (127 * "swallow".hashCode() ^ Arrays.hashCode(this.swallow)) + (127 * "isolation".hashCode() ^ this.isolation.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transactional)) {
            return false;
        }
        Transactional spec = (Transactional)o;
        return this.reason.equals(spec.reason()) && Arrays.equals(this.commitOn, spec.commitOn()) && Arrays.equals(this.retryOn, spec.retryOn()) && Arrays.equals(this.swallow, spec.swallow()) && this.isolation == spec.isolation();
    }

    @Override
    public String toString() {
        return String.format("@%s(reason=%s, commitOn=%s, retryOn=%s, swallow=%s, isolation=%s)", new Object[]{this.annotationType().getName(), this.reason, Arrays.toString(this.commitOn), Arrays.toString(this.retryOn), Arrays.toString(this.swallow), this.isolation});
    }
}

