/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.transaction.RetryController;
import org.sonatype.nexus.transaction.Transaction;

public abstract class TransactionSupport
implements Transaction {
    private boolean active = false;
    private int retries = 0;
    private String reason = "transaction";

    @Override
    public final void begin() {
        Preconditions.checkState((!this.active ? 1 : 0) != 0, (Object)"Transaction has already begun");
        this.doBegin();
        this.active = true;
    }

    protected void doBegin() {
    }

    @Override
    public final void commit() {
        this.active = false;
        this.doCommit();
        this.retries = 0;
    }

    protected abstract void doCommit();

    @Override
    public final void rollback() {
        this.active = false;
        this.doRollback();
    }

    protected abstract void doRollback();

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean allowRetry(Exception cause) {
        if (RetryController.INSTANCE.allowRetry(this.retries, cause)) {
            ++this.retries;
            return true;
        }
        this.retries = 0;
        return false;
    }

    @Override
    public void reason(String reason) {
        this.reason = (String)Preconditions.checkNotNull((Object)reason);
    }

    @Override
    public String reason() {
        return this.reason;
    }
}

