/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

class RollingStats {
    private final AtomicIntegerArray buckets;
    private final TimeUnit tickUnit;
    private volatile long tick;

    public RollingStats(int size, TimeUnit tickUnit) {
        this.buckets = new AtomicIntegerArray(size);
        this.tickUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)tickUnit)));
        this.tick = this.currentTick();
    }

    public void mark() {
        this.maybeShiftWindow();
        this.buckets.getAndIncrement(this.index(this.tick));
    }

    public int sum() {
        this.maybeShiftWindow();
        return IntStream.range(0, this.buckets.length()).map(this.buckets::get).sum();
    }

    private long currentTick() {
        return this.tickUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    private int index(long _tick) {
        return (int)(_tick % (long)this.buckets.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeShiftWindow() {
        long newTick = this.currentTick();
        if (this.tick < newTick) {
            RollingStats rollingStats = this;
            synchronized (rollingStats) {
                if (this.tick < newTick) {
                    LongStream.rangeClosed(this.tick + 1L, newTick).limit(this.buckets.length()).mapToInt(this::index).forEach(i -> this.buckets.set(i, 0));
                    this.tick = newTick;
                }
            }
        }
    }
}

