/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.firewall;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.proxy.ProxyFacet;

@Facet.Exposed
public abstract class QuarantinedVersionFacetSupport
extends FacetSupport {
    public static final String CLM_CAPABILITY_TYPE_ID = "firewall.audit";
    public static final String REPOSITORY_KEY = "repository";
    private final CapabilityRegistry capabilityRegistry;
    private ReentrantReadWriteLock allowedVersionsCacheLock = new ReentrantReadWriteLock();
    private javax.cache.expiry.Duration effectiveCacheDuration;

    protected QuarantinedVersionFacetSupport(CapabilityRegistry capabilityRegistry) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
    }

    protected boolean isFirewallEnabled() {
        Repository repository = this.getRepository();
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter capabilityReferenceFilter = CapabilityReferenceFilterBuilder.capabilities().withType(new CapabilityType(CLM_CAPABILITY_TYPE_ID)).withProperty(REPOSITORY_KEY, repository.getName()).enabled();
        Collection capabilityReferences = this.capabilityRegistry.get((Predicate)capabilityReferenceFilter);
        return !capabilityReferences.isEmpty();
    }

    protected abstract String getCacheName();

    protected javax.cache.expiry.Duration getCacheDuration() {
        javax.cache.expiry.Duration cacheDuration;
        Duration metadataMaxAge = ((ProxyFacet)this.getRepository().facet(ProxyFacet.class)).getConfiguration().getMetadataMaxAge();
        this.effectiveCacheDuration = cacheDuration = new javax.cache.expiry.Duration(TimeUnit.MINUTES, metadataMaxAge.toMinutes());
        this.log.debug("Using metadataMaxAge for repository {}: {} {}", new Object[]{this.getRepository().getName(), cacheDuration.getDurationAmount(), cacheDuration.getTimeUnit()});
        return cacheDuration;
    }

    public javax.cache.expiry.Duration getEffectiveCacheDuration() {
        return this.effectiveCacheDuration;
    }

    protected abstract void destroyCache();

    public void clearCache() {
        this.allowedVersionsCacheLock.writeLock().lock();
        try {
            this.destroyCache();
        }
        finally {
            this.allowedVersionsCacheLock.writeLock().unlock();
        }
    }

    protected void doStop() {
        this.allowedVersionsCacheLock.writeLock().lock();
        try {
            this.destroyCache();
        }
        finally {
            this.allowedVersionsCacheLock.writeLock().unlock();
        }
    }

    protected void doDelete() {
        this.allowedVersionsCacheLock.writeLock().lock();
        try {
            this.destroyCache();
        }
        finally {
            this.allowedVersionsCacheLock.writeLock().unlock();
        }
    }
}

