/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.repair.datastore;

import com.sonatype.nexus.repository.content.npm.INpmHostedFacet;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@Named
@Facet.Exposed
public class NpmRepairComponent
extends NpmFacetSupport {
    @Inject
    protected NpmRepairComponent(NpmPackageParser npmPackageParser) {
        super(npmPackageParser);
    }

    public void repairRepositoryRoot(Blob blob, Repository repository) {
        NpmContentFacet facet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        if (!this.findRepositoryRootAsset().isPresent()) {
            facet.putRepositoryRoot((Payload)new DetachedBlobPayload(blob));
        }
    }

    public void repairSearchIndex(Blob blob, Repository repository) {
        ((NpmContentFacet)repository.facet(NpmContentFacet.class)).putSearchIndex((Payload)new DetachedBlobPayload(blob));
    }

    public void repairPackageRoot(String npmPackageId, Blob blob, Repository repository) throws IOException {
        NpmPackageId id = NpmPackageId.parse(npmPackageId);
        NpmContentFacet facet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        if (!facet.get(id).isPresent()) {
            facet.put(id, (Payload)new DetachedBlobPayload(blob));
        }
    }

    public void repairTarball(String npmPackageId, String tarballName, Blob blob, Repository repository) throws IOException {
        String version;
        NpmPackageId id = NpmPackageId.parse(npmPackageId);
        NpmContentFacet facet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        if (!facet.get(id, version = NpmCoordinateUtil.extractVersion(tarballName)).isPresent()) {
            Optional npmHostedFacet = repository.optionalFacet(INpmHostedFacet.class);
            if (npmHostedFacet.isPresent()) {
                Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson(() -> ((Blob)blob).getInputStream());
                ((INpmHostedFacet)npmHostedFacet.get()).putPackage(packageJson, (Payload)new DetachedBlobPayload(blob));
            } else {
                Map<String, Object> attributes = this.maybeExtractFormatAttributes(npmPackageId, version, () -> ((Blob)blob).getInputStream());
                facet.put(id, tarballName, version, attributes, (Payload)new DetachedBlobPayload(blob));
            }
        }
    }
}

