/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.orient.upgrade;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="npm", from="1.0", to="1.1")
@DependsOn(model="config", version="1.8", checkpoint=true)
public class NpmPCCSAndFirewallAuditCapabilityOutOfSyncUpgrade_1_1
extends DatabaseUpgradeSupport {
    private final Provider<DatabaseInstance> configDatabaseInstance;

    @Inject
    public NpmPCCSAndFirewallAuditCapabilityOutOfSyncUpgrade_1_1(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance) {
        this.configDatabaseInstance = Objects.requireNonNull(configDatabaseInstance);
    }

    public void apply() {
        List<RepositoryDTO> npmRepositories = this.getNpmRepositories();
        List<FirewallAuditCapabilityDTO> firewallAuditCapabilities = this.getFirewallAuditCapabilities();
        List<String> repositoriesToUpdate = npmRepositories.stream().filter(npmRepository -> {
            FirewallAuditCapabilityDTO firewallAuditCapability = this.getFirewallAuditCapabilityDTOByRepository((RepositoryDTO)npmRepository, firewallAuditCapabilities).orElse(null);
            return this.isFirewallAuditCapabilityDisabled(firewallAuditCapability);
        }).filter(npmRepository -> npmRepository.removeQuarantinedVersions).map(it -> it.name).collect(Collectors.toList());
        this.disablePCCS(repositoriesToUpdate);
    }

    private boolean isFirewallAuditCapabilityDisabled(@Nullable FirewallAuditCapabilityDTO firewallAuditCapability) {
        return firewallAuditCapability == null || !firewallAuditCapability.enabled || !firewallAuditCapability.quarantine;
    }

    private List<RepositoryDTO> getNpmRepositories() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx oDatabaseDocumentTx = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            List documents = oDatabaseDocumentTx.query((OQuery)new OSQLSynchQuery("select from repository where recipe_name = 'npm-proxy'"), new Object[0]);
            return documents.stream().map(it -> this.toRepositoryDTO((ODocument)it)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<FirewallAuditCapabilityDTO> getFirewallAuditCapabilities() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx oDatabaseDocumentTx = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            List documents = oDatabaseDocumentTx.query((OQuery)new OSQLSynchQuery("select from capability where type = 'firewall.audit'"), new Object[0]);
            return documents.stream().map(it -> this.toFirewallAuditCapabilityDTO((ODocument)it)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Optional<FirewallAuditCapabilityDTO> getFirewallAuditCapabilityDTOByRepository(RepositoryDTO repository, List<FirewallAuditCapabilityDTO> capabilities) {
        return capabilities.stream().filter(it -> it.repository.equals(repositoryDTO.name)).findFirst();
    }

    private boolean parseBoolean(@Nullable Object value) {
        return value != null && Boolean.parseBoolean(value.toString());
    }

    private RepositoryDTO toRepositoryDTO(ODocument oDocument) {
        String name = (String)oDocument.field("repository_name");
        Map attributes = (Map)oDocument.field("attributes");
        HashMap npm = (HashMap)attributes.get("npm");
        if (npm == null) {
            npm = new HashMap();
        }
        boolean removeQuarantinedVersions = this.parseBoolean(npm.get("removeQuarantinedVersions"));
        RepositoryDTO repositoryDTO = new RepositoryDTO();
        repositoryDTO.name = name;
        repositoryDTO.removeQuarantinedVersions = removeQuarantinedVersions;
        return repositoryDTO;
    }

    private FirewallAuditCapabilityDTO toFirewallAuditCapabilityDTO(ODocument oDocument) {
        boolean enabled = (Boolean)oDocument.field("enabled");
        Map properties = (Map)oDocument.field("properties");
        String repository = properties.get("repository").toString();
        boolean quarantine = this.parseBoolean(properties.get("quarantine"));
        FirewallAuditCapabilityDTO firewallAuditCapability = new FirewallAuditCapabilityDTO();
        firewallAuditCapability.enabled = enabled;
        firewallAuditCapability.repository = repository;
        firewallAuditCapability.quarantine = quarantine;
        return firewallAuditCapability;
    }

    private void disablePCCS(List<String> repositoryNames) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx oDatabaseDocumentTx = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            OCommandSQL commandSQL = new OCommandSQL("update repository  set attributes.npm.removeQuarantinedVersions = false  where recipe_name = 'npm-proxy' and repository_name in ? ");
            oDatabaseDocumentTx.command((OCommandRequest)commandSQL).execute(new Object[]{repositoryNames});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class FirewallAuditCapabilityDTO {
        String repository;
        boolean enabled;
        boolean quarantine;

        private FirewallAuditCapabilityDTO() {
        }
    }

    private static class RepositoryDTO {
        String name;
        boolean removeQuarantinedVersions;

        private RepositoryDTO() {
        }
    }
}

