/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.NpmUploadHandler;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.internal.orient.OrientNpmHostedFacet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.importtask.ImportResult;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.PathPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@Named(value="npm")
public class OrientNpmUploadHandler
extends UploadHandlerSupport
implements NpmUploadHandler {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;
    private final NpmPackageParser npmPackageParser;

    @Inject
    public OrientNpmUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") @Named(value="simple") VariableResolverAdapter variableResolverAdapter, NpmPackageParser npmPackageParser, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = (VariableResolverAdapter)Preconditions.checkNotNull((Object)variableResolverAdapter);
        this.npmPackageParser = (NpmPackageParser)((Object)Preconditions.checkNotNull((Object)((Object)npmPackageParser)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        OrientNpmHostedFacet facet = (OrientNpmHostedFacet)repository.facet(OrientNpmHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        if (!payload.getName().endsWith(".tgz")) {
            throw new IllegalArgumentException("Unsupported extension. Extension must be .tgz");
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, NpmFacetUtils.HASH_ALGORITHMS);){
            UploadResponse uploadResponse;
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson((InputStreamSupplier)tempBlob);
            this.ensureNpmPermitted(repository, packageJson, false);
            UnitOfWork.begin((Supplier)storageFacet.txSupplier());
            try {
                uploadResponse = new UploadResponse(facet.putPackage(packageJson, tempBlob));
            }
            catch (Throwable throwable2) {
                UnitOfWork.end();
                throw throwable2;
            }
            UnitOfWork.end();
            return uploadResponse;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        this.ensurePermitted(configuration.getRepository().getName(), "npm", configuration.getAssetName(), Collections.emptyMap());
        return this.doPut(configuration);
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("npm", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public boolean supportsExportImport() {
        return true;
    }

    /*
     * Loose catch block
     */
    @Override
    public Content doPut(ImportFileConfiguration configuration) throws IOException {
        if (configuration.getAssetName().endsWith("package.json")) {
            return null;
        }
        Repository repository = configuration.getRepository();
        OrientNpmHostedFacet npmFacet = (OrientNpmHostedFacet)repository.facet(OrientNpmHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        File content = configuration.getFile();
        Path contentPath = content.toPath();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (configuration.isHardLinkingEnabled()) {
            AssetBlob tarballAssetBlob = npmFacet.getHardLinkingTarballBlob(content);
            InputStreamSupplier is = () -> tarballAssetBlob.getBlob().getInputStream();
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson(is);
            this.ensureNpmPermitted(repository, packageJson, false);
            Asset asset = npmFacet.putPackage(packageJson, tarballAssetBlob);
            return NpmFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
        }
        Throwable throwable = null;
        Object var9_12 = null;
        try (PathPayload payload = new PathPayload(contentPath, Files.probeContentType(contentPath));){
            Content content2;
            TempBlob tempBlob;
            Throwable throwable2;
            block21: {
                throwable2 = null;
                Object var12_19 = null;
                tempBlob = storageFacet.createTempBlob((Payload)payload, NpmFacetUtils.HASH_ALGORITHMS);
                Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson((InputStreamSupplier)tempBlob);
                this.ensureNpmPermitted(repository, packageJson, false);
                Asset asset = npmFacet.putPackage(packageJson, tempBlob);
                content2 = NpmFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
                if (tempBlob == null) break block21;
                tempBlob.close();
            }
            return content2;
            {
                catch (Throwable throwable3) {
                    try {
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public void handleAfterImport(ImportResult importResult) {
        List<ImportResult.FileAsset> packageRootCandidates = this.getPackageRootCandidates(importResult);
        for (ImportResult.FileAsset packageRootCandidate : packageRootCandidates) {
            try {
                this.processFileAsset(importResult.getRepository(), packageRootCandidate);
            }
            catch (Exception e) {
                this.log.debug("Unable to handle package root {}", (Object)packageRootCandidate.getFile(), (Object)e);
            }
        }
    }

    private List<ImportResult.FileAsset> getPackageRootCandidates(ImportResult importResult) {
        return importResult.getFileAssets().stream().filter(it -> it.getAssetName().endsWith("package.json")).collect(Collectors.toList());
    }

    private void processFileAsset(Repository repository, ImportResult.FileAsset fileAsset) throws IOException {
        NestedAttributesMap packageRoot;
        try {
            packageRoot = NpmJsonUtils.parse(() -> new FileInputStream(fileAsset.getFile()));
        }
        catch (IOException e) {
            this.log.warn("Unable to extract package root {}", (Object)fileAsset.getFile(), (Object)e);
            return;
        }
        String name = (String)packageRoot.get("name", String.class);
        Map distTags = (Map)packageRoot.get("dist-tags");
        TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(IOException.class).run(() -> {
            NpmPackageId npmPackageId = NpmPackageId.parse(name);
            ((OrientNpmHostedFacet)repository.facet(OrientNpmHostedFacet.class)).attachDistTags(npmPackageId, distTags);
        });
    }
}

