/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.orient;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.filter.export.OrientExportAssetFilter;
import org.sonatype.nexus.repository.storage.Asset;

@Singleton
@Named(value="npm")
public class NpmOrientExportAssetFilter
extends ComponentSupport
implements OrientExportAssetFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldSkipAsset(Asset asset) {
        int n;
        try {
            String string = Objects.requireNonNull(asset.contentType()).toLowerCase();
            n = -1;
            switch (string.hashCode()) {
                case -1348220909: {
                    if (!string.equals("application/x-tgz")) break;
                    n = 1;
                    break;
                }
                case -43923783: {
                    if (!string.equals("application/gzip")) break;
                    n = 1;
                    break;
                }
                case -43840953: {
                    if (!string.equals("application/json")) break;
                    n = 1;
                    break;
                }
                case 1154455342: {
                    if (!string.equals("application/x-gzip")) break;
                    n = 1;
                    break;
                }
                case 1178484637: {
                    if (!string.equals("application/octet-stream")) break;
                    n = 1;
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        {
        }
        switch (n) {
            case 1: {
                return false;
            }
        }
        return true;
    }

    public boolean shouldSkipAttributes(Asset asset) {
        try {
            String contentType = Objects.requireNonNull(asset.contentType());
            return !contentType.equalsIgnoreCase("application/gzip") && !contentType.equalsIgnoreCase("application/octet-stream");
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
    }

    public String getAssetExportName(Asset asset) {
        try {
            if (Objects.requireNonNull(asset.contentType()).equalsIgnoreCase("application/json")) {
                String nameWithoutScope = asset.name();
                if (nameWithoutScope.startsWith("@") && nameWithoutScope.contains("/")) {
                    nameWithoutScope = nameWithoutScope.substring(nameWithoutScope.lastIndexOf(47) + 1);
                }
                return String.format("%s/-/%s.package.json", asset.name(), nameWithoutScope);
            }
            return asset.name();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

