/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.tasks.datastore;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmPackageRootMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import com.sonatype.nexus.repository.npm.internal.tasks.BaseRebuildNpmMetadataTask;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Named
public class RebuildNpmMetadataTask
extends BaseRebuildNpmMetadataTask {
    private static final int ASSET_BROWSE_LIMIT = 1000;
    private final NpmPackageParser npmPackageParser;

    @Inject
    public RebuildNpmMetadataTask(@Named(value="hosted") @Named(value="hosted") Type hostedType, @Named(value="npm") @Named(value="npm") Format npmFormat, NpmPackageParser npmPackageParser) {
        super(hostedType, npmFormat);
        this.npmPackageParser = npmPackageParser;
    }

    @Override
    protected void rebuildMetadata(Repository repository) {
        NpmHostedFacet npmHostedFacet = (NpmHostedFacet)repository.facet(NpmHostedFacet.class);
        NpmContentFacet npmContentFacet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        FluentQuery query = npmContentFacet.assets().byKind(NpmAttributes.AssetKind.TARBALL.name());
        Continuation assets = query.browse(1000, null);
        while (!this.isCanceled() && !assets.isEmpty()) {
            assets.forEach(asset -> this.updatePackageRoot((FluentAsset)asset, repository, npmContentFacet, npmHostedFacet));
            assets = query.browse(1000, assets.nextContinuationToken());
        }
        query = npmContentFacet.assets().byKind(NpmAttributes.AssetKind.PACKAGE_ROOT.name());
        assets = query.browse(1000, null);
        while (!this.isCanceled() && !assets.isEmpty()) {
            assets.forEach(asset -> this.repairMetadata(repository, StringUtils.removeStart((String)asset.path(), (String)"/"), npmContentFacet));
            assets = query.browse(1000, assets.nextContinuationToken());
        }
    }

    @Override
    protected void rebuildMetadata(Repository repository, String packageName) {
        NpmHostedFacet npmHostedFacet = (NpmHostedFacet)repository.facet(NpmHostedFacet.class);
        NpmContentFacet npmContentFacet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        FluentQuery query = npmContentFacet.assets().byFilter("kind = #{filterParams.kind} AND path LIKE #{filterParams.path}", (Map)ImmutableMap.of((Object)"kind", (Object)NpmAttributes.AssetKind.TARBALL.name(), (Object)"path", (Object)(String.valueOf('/') + packageName + '%')));
        Continuation assets = query.browse(1000, null);
        while (!this.isCanceled() && !assets.isEmpty()) {
            assets.forEach(asset -> this.updatePackageRoot((FluentAsset)asset, repository, npmContentFacet, npmHostedFacet));
            assets = query.browse(1000, assets.nextContinuationToken());
        }
        this.repairMetadata(repository, packageName, npmContentFacet);
    }

    private void repairMetadata(Repository repository, String packageName, NpmContentFacet npmContentFacet) {
        if (!this.isCanceled()) {
            try {
                boolean isChanged;
                NpmPackageId packageId = NpmPackageId.parse(packageName);
                NestedAttributesMap packageRoot = NpmFacetSupport.loadPackageRoot(packageId, npmContentFacet).orElse(null);
                if (packageRoot != null && (isChanged = this.removeVersionsWithBuildMetadata(packageRoot))) {
                    this.savePackageRoot(npmContentFacet, packageId, packageRoot);
                }
            }
            catch (IOException e) {
                this.log.error("Error occurred while rebuilding npm metadata {} in repository {}", new Object[]{packageName, repository.getName(), e});
            }
        }
    }

    private void updatePackageRoot(FluentAsset asset, Repository repository, NpmContentFacet contentFacet, NpmHostedFacet npmHostedFacet) {
        BlobRef blobRef = ((AssetBlob)asset.blob().orElseThrow(() -> new IllegalStateException("Blob is missing for asset: " + asset.path()))).blobRef();
        Blob blob = (Blob)contentFacet.blobs().blob(blobRef).orElseThrow(() -> new IllegalStateException("Blob is missing for asset: " + asset.path()));
        Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson(() -> ((Blob)blob).getInputStream());
        NpmPackageId packageId = NpmPackageId.parse((String)packageJson.get("name"));
        NestedAttributesMap packageJsonAttributesMap = new NestedAttributesMap("metadata", packageJson);
        try {
            NestedAttributesMap updatedMetadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(packageJsonAttributesMap, repository.getName(), blob.getMetrics().getSha1Hash(), RebuildNpmMetadataTask.getPackageRootLatestVersion(packageJsonAttributesMap, contentFacet), NpmVersionComparator.extractNewestVersion);
            npmHostedFacet.putPackageRoot(packageId, null, updatedMetadata);
        }
        catch (IOException e) {
            this.log.error("Failed to update package root, packageId: {}", (Object)packageId, (Object)e);
        }
    }

    private static String getPackageRootLatestVersion(NestedAttributesMap packageJson, NpmContentFacet contentFacet) throws IOException {
        NestedAttributesMap packageRoot;
        String latestVersion;
        NpmPackageId packageId = NpmPackageId.parse((String)packageJson.get("name"));
        Optional<Content> maybePackageRootContent = contentFacet.get(packageId);
        if (maybePackageRootContent.isPresent() && Objects.nonNull(latestVersion = NpmMetadataUtils.getLatestVersionFromPackageRoot(packageRoot = NpmJsonUtils.parse(() -> ((Content)maybePackageRootContent.get()).openInputStream())))) {
            return latestVersion;
        }
        return "";
    }

    private void savePackageRoot(NpmContentFacet npmContentFacet, NpmPackageId packageId, NestedAttributesMap packageRoot) throws IOException {
        packageRoot.remove("_id");
        byte[] bytes = NpmJsonUtils.bytes(packageRoot);
        npmContentFacet.put(packageId, (Payload)new StreamPayload(() -> new ByteArrayInputStream(bytes), (long)bytes.length, "application/json"));
    }
}

