/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class ReindexNpmRepositoryManager
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;
    private final boolean enabled;
    private final UnprocessedRepositoryChecker unprocessedRepositoryChecker;

    @Inject
    public ReindexNpmRepositoryManager(TaskScheduler taskScheduler, RepositoryManager repositoryManager, UnprocessedRepositoryChecker unprocessedRepositoryChecker, @Named(value="${nexus.npm.reindexOnStartup.enabled:-true}") @Named(value="${nexus.npm.reindexOnStartup.enabled:-true}") boolean enabled) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.unprocessedRepositoryChecker = (UnprocessedRepositoryChecker)Preconditions.checkNotNull((Object)unprocessedRepositoryChecker);
        this.enabled = enabled;
    }

    protected void doStart() {
        if (!this.enabled) {
            return;
        }
        try {
            for (Repository repository : this.repositoryManager.browse()) {
                boolean existingTask;
                if (!this.unprocessedRepositoryChecker.isUnprocessedNpmRepository(repository) || (existingTask = this.taskScheduler.findAndSubmit("repository.npm.reindex", (Map)ImmutableMap.of((Object)"repositoryName", (Object)repository.getName())))) continue;
                this.runReindexTaskForRepository(repository);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to determine if any npm repositories needed to be reindexed", (Throwable)e);
        }
    }

    private void runReindexTaskForRepository(Repository repository) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.npm.reindex");
        configuration.setString("repositoryName", repository.getName());
        configuration.setName("Reindex npm repository - (" + repository.getName() + ")");
        this.taskScheduler.submit(configuration);
    }

    public static interface UnprocessedRepositoryChecker {
        public boolean isUnprocessedNpmRepository(Repository var1);
    }
}

