/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.security;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.token.BearerTokenManager;
import org.sonatype.nexus.security.token.BearerTokenRealm;

@Named
@Singleton
public class NpmTokenManager
extends BearerTokenManager {
    private final BearerTokenRealm npmTokenRealm;

    @Inject
    public NpmTokenManager(ApiKeyStore apiKeyStore, SecurityHelper securityHelper, @Named(value="NpmToken") @Named(value="NpmToken") BearerTokenRealm npmTokenRealm) {
        super(apiKeyStore, securityHelper, "NpmToken");
        this.npmTokenRealm = npmTokenRealm;
    }

    public String login(String username, String password) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)password);
        try {
            AuthenticationInfo authenticationInfo = this.securityHelper.getSecurityManager().authenticate((AuthenticationToken)new UsernamePasswordToken(username, password));
            return super.createToken(authenticationInfo.getPrincipals());
        }
        catch (AuthenticationException e) {
            this.log.debug("Bad credentials provided for npm token creation", (Throwable)e);
            return null;
        }
    }

    public boolean logout() {
        if (super.deleteToken()) {
            this.npmTokenRealm.onLogout(this.securityHelper.subject().getPrincipals());
            return true;
        }
        return false;
    }
}

