/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.v1.sqlsearch;

import com.google.common.base.Strings;
import com.sonatype.nexus.repository.npm.NpmSearchParameterExtractorSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.view.Parameters;

@Named
@Singleton
public class SqlNpmSearchParameterExtractor
extends NpmSearchParameterExtractorSupport {
    @Override
    public String extractText(Parameters parameters) {
        String textParameter = Strings.nullToEmpty((String)parameters.get("text")).trim();
        if (!textParameter.isEmpty()) {
            textParameter = textParameter.replaceAll("scope:", "group:").replaceAll("author:", "assets.attributes.npm.author:").replaceAll("description:", "assets.attributes.npm.description:").replaceAll("keywords:", "assets.attributes.npm.keywords:").replaceAll("license:", "assets.attributes.npm.license:").replaceAll("tagged_is:", "assets.attributes.npm.tagged_is:").replaceAll("tagged_not:", "assets.attributes.npm.tagged_not:");
            textParameter = this.makeWildcardIfNoSearchKeys(textParameter);
        }
        return textParameter;
    }

    @Override
    protected String makeWildcardIfNoSearchKeys(String text) {
        if (!text.contains(":")) {
            return String.valueOf(text) + "*";
        }
        return text;
    }

    @Override
    public List<SearchFilter> getSearchFiltersFromTextParameter(String text) {
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        if (text.contains(":")) {
            Pattern pattern = Pattern.compile("([\\w.]+:\\w+)");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                String[] term = matcher.group().split(":");
                filters.add(new SearchFilter(term[0], term[1]));
            }
        } else {
            filters.add(new SearchFilter("name.raw", text));
            filters.add(new SearchFilter("keywords", text));
            filters.add(new SearchFilter("version", text));
        }
        return filters;
    }
}

