/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.v1.elasticsearch;

import com.google.common.base.Strings;
import com.sonatype.nexus.repository.npm.NpmSearchParameterExtractorSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.view.Parameters;

@Named
@Singleton
public class ElasticSearchNpmSearchParameterExtractor
extends NpmSearchParameterExtractorSupport {
    @Override
    public String extractText(Parameters parameters) {
        String textParameter = Strings.nullToEmpty((String)parameters.get("text")).trim();
        if (!textParameter.isEmpty()) {
            textParameter = textParameter.replaceAll("keywords:", "assets.attributes.npm.keywords:").replaceAll("author:", "assets.attributes.npm.author:").replaceAll("maintainer:", "assets.attributes.npm.author:").replaceAll("is:", "assets.attributes.npm.tagged_is:").replaceAll("not:", "assets.attributes.npm.tagged_not:").replaceAll("scope:", "assets.attributes.npm.scope:");
            textParameter = this.makeWildcardIfNoSearchKeys(textParameter);
        }
        return textParameter;
    }

    @Override
    public List<SearchFilter> getSearchFiltersFromTextParameter(String text) {
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        if (text.contains(":")) {
            Pattern pattern = Pattern.compile("(assets\\.attributes\\.npm\\.\\w+:\\w+)");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                String[] term = matcher.group().split(":");
                filters.add(new SearchFilter(term[0], term[1]));
            }
        } else {
            filters.add(new SearchFilter("name", text));
            filters.add(new SearchFilter("assets.attributes.npm.name", text));
            filters.add(new SearchFilter("assets.attributes.npm.keywords", text));
            filters.add(new SearchFilter("version", text));
        }
        return filters;
    }
}

