/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.v1;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;

@Named
@Singleton
public class NpmSearchHitExtractor
extends ComponentSupport {
    private static final String P_LAST_MODIFIED = "last_modified";

    @Nullable
    public String extractDescription(ComponentSearchResult searchHit) {
        return this.extractNpmAttribute(searchHit, "description", String.class);
    }

    @Nullable
    public String extractAuthorName(ComponentSearchResult searchHit) {
        return this.parseAuthorName(this.extractNpmAttribute(searchHit, "author", String.class));
    }

    @Nullable
    public String extractAuthorEmail(ComponentSearchResult searchHit) {
        return this.parseAuthorEmail(this.extractNpmAttribute(searchHit, "author", String.class));
    }

    public List<String> extractKeywords(ComponentSearchResult searchHit) {
        String keywords = this.extractNpmAttribute(searchHit, "keywords", String.class);
        if (keywords == null) {
            return Collections.emptyList();
        }
        if ((keywords = keywords.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(keywords.split("\\s"));
    }

    @Nullable
    public String extractHomepage(ComponentSearchResult searchHit) {
        return this.extractNpmAttribute(searchHit, "homepage", String.class);
    }

    @Nullable
    public String extractRepositoryUrl(ComponentSearchResult searchHit) {
        return this.extractNpmAttribute(searchHit, "repository_url", String.class);
    }

    @Nullable
    public String extractBugsUrl(ComponentSearchResult searchHit) {
        return this.extractNpmAttribute(searchHit, "bugs_url", String.class);
    }

    @Nullable
    public DateTime extractLastModified(ComponentSearchResult searchHit) {
        Number timestamp = this.extractAttribute(searchHit, "content", P_LAST_MODIFIED, Number.class);
        if (timestamp != null) {
            return new DateTime(timestamp.longValue());
        }
        return null;
    }

    @Nullable
    private <T> T extractNpmAttribute(ComponentSearchResult searchHit, String name, Class<T> klass) {
        return this.extractAttribute(searchHit, "npm", name, klass);
    }

    @Nullable
    private <T> T extractAttribute(ComponentSearchResult searchHit, String mapName, String fieldName, Class<T> klass) {
        return searchHit.getAssets().stream().findAny().map(AssetSearchResult::getAttributes).map(attr -> attr.get(mapName)).filter(Map.class::isInstance).map(Map.class::cast).map(map -> map.get(fieldName)).filter(klass::isInstance).map(klass::cast).orElse(null);
    }

    @Nullable
    private String parseAuthorName(@Nullable String author) {
        String username;
        if (author == null) {
            return null;
        }
        int endIndex = author.indexOf(60);
        if (endIndex == -1) {
            endIndex = author.indexOf(40);
        }
        if ((username = endIndex == -1 ? author.trim() : author.substring(0, endIndex).trim()).isEmpty()) {
            return null;
        }
        return username;
    }

    @Nullable
    private String parseAuthorEmail(@Nullable String author) {
        if (author == null) {
            return null;
        }
        int startIndex = author.indexOf(60);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = author.indexOf(62, startIndex);
        if (endIndex == -1) {
            return null;
        }
        String email = author.substring(startIndex + 1, endIndex).trim();
        if (email.isEmpty()) {
            return null;
        }
        return email;
    }
}

